#ifndef LISTITEM_H
#define LISTITEM_H

#include <windows.h>

/**
 * @ingroup Controls
 * The ListItem represents an element that may be placed inside a FlexList
 * control. It can be overridden to place various types of items in the list.
 * The width is set by the FlexList container. The format function sets the
 * width and returns the height of the object. Thus, lines may be wrapped and
 * the list can contain items of various sizes.
 */
class ListItem
{
public:
    ListItem();
    virtual ~ListItem();

    virtual int width()=0;
    virtual int height()=0;

    virtual int format( int width )=0;
    virtual void draw( HDC dc, int x, int y )=0;
    virtual void select( bool sel );
    bool isSelected();

    // vertical position
    int pos;
    bool _selected;
};


#endif // LISTITEM_H
