#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include "Map.h"
#include "debug.h" // must be last

MapBase::MapBase()
{
    construct(499);
}

MapBase::MapBase( unsigned size )
{
    construct( nextPrimeNumber( size ) );
}

unsigned 
MapBase::nextPrimeNumber( unsigned size )
{
    if ( size == 0 ) {
        size = 2;
    }

    for ( unsigned i = 2; i < size; i++ ) {
        if ( ( size % i ) == 0 ) {
            size++;
            i = 2;
        }
    }

    return size;
}

void
MapBase::construct( unsigned size ) 
{
    entries_alloc = size; // prime
    entries = (Entry_t**)malloc( entries_alloc * sizeof(Entry_t*));
    memset( entries, 0, entries_alloc * sizeof(Entry_t*));
    pos = 0;
    index = 0;
    allowDuplicates = false;
}

void
MapBase::destruct()
{
    int i;
    for ( i = 0; i < entries_alloc; i++ ) {
        Entry_t* cur = entries[i];
        while( cur ) {
            Entry_t* next = cur->next;
            free( cur );
            cur = next;
        }
    }

    free( entries );
}

void
MapBase::clear()
{
    destruct();
    construct(entries_alloc);
}

MapBase::~MapBase()
{
    destruct();
}

bool
MapBase::add( void* key, void* value )
{
    unsigned h = hash( key );

    Entry_t* cur = entries[h];
    if ( !allowDuplicates ) {
        while ( cur ) {
            if ( cur->key == key ) {
                return false;
            }

            cur = cur->next;
        }
    }

    cur = (Entry_t*)malloc( sizeof(Entry_t));
    cur->key = key;
    cur->value = value;
    cur->next = entries[h];
    entries[h] = cur;
    return true;
}

bool
MapBase::lookup( void* key, void** value )
{
    unsigned h = hash( key );

    Entry_t* cur = entries[h];
    while ( cur ) {
        if ( cur->key == key ) {
            *value = cur->value;
            return true;
        }

        cur = cur->next;
    }
    return false;
}

void*
MapBase::first()
{
    index = -1;
    pos = 0;
    return next();
}

void*
MapBase::next()
{
    for( ;; ) {
        if ( pos ) {
            pos = pos->next;
            if ( pos ) {
                return pos->value;
            }
        }

        if ( index == entries_alloc - 1 ) {
            return 0;
        }
        index++;
        pos = entries[index];
        if ( pos ) {
            return pos->value;
        }
    }
}

unsigned 
MapBase::hash( void* key )
{
    return (unsigned)key % entries_alloc;
}
