#ifndef NavWindow_H
#define NavWindow_H

#include "BaseWnd.h"
#include "ButtonBar.h"
#include "Bitmap.h"
#include "DibImage.h"

/**
 * @ingroup Controls
 * The NavWindow control is a small, moveable window that the user may use to
 * navigate around a large image. It displays a thumbnail and allows the user
 * to move the viewport around. The zoom and movement commands are communicated
 * to the parent window through WM_COMMAND notifications. The command
 * identifiers are:
 \code
 NavWindow::IDC_FULL_SCREEN=1
 NavWindow::IDC_ZOOM_1_1
 NavWindow::IDC_ZOOM_OUT
 NavWindow::IDC_ZOOM_IN
 NavWindow::IDC_MOVE
 \endcode
 */
class NavWindow : public Window
{
public:
    NavWindow(HINSTANCE);
    ~NavWindow();

    void create(HWND hParent, int x, int y, int cx, int cy);
    void setImage( DibImageRef image );
    void setDisplayArea( RECT* rect );
    RECT getDisplayArea();
    void fixIfOffscreen();

    enum Commands {
        IDC_FULL_SCREEN=1,
        IDC_ZOOM_1_1,
        IDC_ZOOM_OUT,
        IDC_ZOOM_IN,
        IDC_MOVE
    };

private:
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);

    void onClose(HWND);
    void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
    BOOL onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct);
    void onDestroy(HWND hwnd);
    void onKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags);
    void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    void onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
    void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    void onPaint(HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient);
    void onSize(HWND hwnd, UINT state, int cx, int cy);
    void calcLayout();
    void placeDragger();

    HWND _hParent;
    DibImageRef _image;
    ButtonBar _toolBar;
    int _toolBarHeight;
    Brush _backBrush;
    Bitmap _dragger;
    RECT _displayRect;
    RECT _dragRect;
    RECT _destRect;
    double _scale;
};

#endif // NavWindow_H
