#ifndef ScrollWindow_H
#define ScrollWindow_H

#include "BaseWnd.h"

/**
 * The ScrollWindow has scrollbars and handles the dirty work of scrolling
 * around. To take advantage of this, override the onDraw() function instead of
 * onPaint(). The device contexts coordinates will already be adjusted to
 * reflect scrolling.
 */
class ScrollWindow : public Window
{
public:
    ScrollWindow(HINSTANCE);
    ~ScrollWindow();

    void create();

protected:
    virtual void onDraw(HDC dc);

    void setScrollBars( int pixelsPerUnitX, int pixelsPerUnitY, int noUnitsX, int noUnitsY);
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);
    void onSize(HWND hwnd, UINT state, int cx, int cy);
    void scrollTo( int x, int y );
    int getScrollX();
    int getScrollY();
    virtual void onScroll( int x, int y );

private:

    void onClose(HWND);
    void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
    BOOL onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct);
    void onDestroy(HWND hwnd);
    void onKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags);
    void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    void onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
    void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    void onPaint(HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient);
    void onVScroll( HWND hwnd, HWND hwndCtl, UINT code, int pos );
    void onHScroll( HWND hwnd, HWND hwndCtl, UINT code, int pos );
    void format();

    int _pixelsPerUnitX;
    int _pixelsPerUnitY;
    int _noUnitsX;
    int _noUnitsY;
    int _height;
    int _width;
    int _posX;
    int _posY;
    int _pageX;
    int _pageY;
};

#endif // ScrollWindow_H
