#ifndef SMARTREF_H
#define SMARTREF_H

/**
 * Implements a reference counting smart pointer. The pointer is not
 * threadsafe.
 */
template <class T>
class SmartRef
{
public:
    SmartRef( T* p )
    {
        refCount = new int;
        *refCount = 1;
        pointer = p;
    }

    SmartRef()
    {
        refCount = new int;
        *refCount = 1;
        pointer = 0;
    }

    SmartRef( const SmartRef& other )
    {
        refCount = other.refCount;
        ++(*refCount);
        pointer = other.pointer;
    }

    SmartRef& operator=(const SmartRef& other )
    {
        release();
        refCount = other.refCount;
        ++(*refCount);
        pointer = other.pointer;
        return *this;
    }

    SmartRef& operator=(T* p)
    {
        release();
        refCount = new int;
        *refCount = 1;
        pointer = p;
        return *this;
    }

    ~SmartRef()
    {
        release();
    }

    operator bool() const
    {
        return pointer != 0;
    }

    T& operator*() const 
    {
        return *pointer;
    }

    T* operator->()
    {
        return pointer;
    }

    T* ptr() { return pointer; }

private:
    void release()
    {
        --(*refCount);
        if ( *refCount == 0 ) {
            delete refCount;
            delete pointer;
        }
    }

    int* refCount;
    T* pointer;
};

#endif // SMARTREF_H
