#ifndef SplitWindow_H
#define SplitWindow_H

#include "BaseWnd.h"

class SplitWindow;

/**
 * The splitter represents a splitter bar inside a SplitWindow control. It has
 * a first and second pane, and it can b a horizontal or veritcal split.
 */
class Splitter
{
public:
    Splitter( bool horizontal );
    ~Splitter();

    void setPane( bool second, HWND hChild );
    void setPane( bool second, Splitter* splitter );
    void format( RECT* newRect );
    void draw( HDC hdc );
    bool setSplitInfo( HWND hwnd, int minWidth, int minHeight, int maxWidth, int maxHeight );
    bool setSize( HWND hwnd, int width, int height, RECT* );
    void setThickness( int pixels );

private:

    void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    void onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
    void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, 
                               UINT keyFlags);
    void move();
    void swap( RECT* rect );
    bool horizontal;
    RECT barRect();
    HWND hFirst;
    HWND hSecond;

    Splitter* first;
    Splitter* second;
    RECT rect;
    int pos;
    int thickness;
    friend class SplitWindow;
    bool _dragging;
    POINT _dragStart;
    int _posStart;
    bool _over;
    int _setWidth[2];
    int _setHeight[2];
    bool _immobile;

    struct SplitInfo {
        int minWidth;
        int minHeight;
        int maxWidth;
        int maxHeight;
    } _info[2];

    void getSplitInfo(SplitInfo* info);

    // merge info1 into info2
    void merge( SplitInfo* info1, SplitInfo* info2 );
};

/**
 * The SplitWindow acts as a container for other windows, which may be split by
 * Splitter objects. Each splitter object has a first and second pane. The
 * SplitWindow must have at least one splitter.
 */
class SplitWindow : public Window
{
public:
    SplitWindow(HINSTANCE);
    ~SplitWindow();

    void create(HWND hParent);
    void setMainSplitter(Splitter* splitter);

protected:
    void drawSplitters(HDC hdc);

	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);

    void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    void onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
    void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    void onPaint(HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient);
    void onSize(HWND hwnd, UINT state, int cx, int cy);
private:

    Splitter* _mainSplitter;
};

#endif // SplitWindow_H
