#include "StringList.h"
#include <stdlib.h>
#include <string.h>
#include "debug.h" // must be last

StringList::StringList()
{
}

StringList::~StringList()
{
    clear();
}

const TCHAR*
StringList::first() const
{
    return _list.first();
}


const TCHAR*
StringList::next() const
{
    return _list.next();
}

void
StringList::remove()
{
    free( _list.cur() );
    _list.remove();
}

void
StringList::clear()
{
    TCHAR* cur = _list.first();
    while( cur ) {
        free( cur );
        cur = _list.next();
    }
    _list.clear();
}

void
StringList::addTail( const TCHAR* item )
{
    _list.addTail( _tcsdup( item ) );
}

bool
StringList::empty()
{
    return _list.empty();
}

StringList& 
StringList::operator=( const StringList& other )
{
    clear();
    const TCHAR* ptr = other.first();
    while( ptr ) {
        addTail( ptr );
        ptr = other.next();
    }

    return *this;
}

bool
StringList::operator==( const StringList& other )
{
    const TCHAR* mine = _list.first();
    const TCHAR* theirs = other.first();
    while( mine && theirs ) {
        if ( 0 != _tcscmp( mine, theirs ) ) {
            return false;
        }

        mine = _list.next();
        theirs = other.next();
    }

    return mine == theirs;
}
