/****************************************************************
This file is part of the SkinScript library, and is provided
for educational purposes only.

The SkinScript library is Copyright 2000 Steve Hanov.
YOU MAY NOT INCORPORATE THE SKINSCRIPT LIBRARY INTO OTHER WORKS
IN WHOLE OR IN PART WITHOUT EXPRESS WRITTEN CONSENT FROM THE
COPYRIGHT HOLDER.

For more information, contact the author at smhanov@uwaterloo.ca
*****************************************************************/
//*******************************************************************
//CTagParser
//By Steve Hanov (smhanov@uwaterloo.ca)
//March 1998
//
// Provides limited parsing of HTML-style files. (tags only)
// Note: Technically, this is merely a "Scanner"
//******************************************************************

#include <string>
#include <list>
#include <vector>
#include <map>
#include <tchar.h>

#define MAX_TAG_NAME_LENGTH				32
#define MAX_TAG_ATTRIBUTE_NAME_LENGTH	32	
#define MAX_TAG_ATTRIBUTE_VALUE_LENGTH	4096	

enum PARSESTATE
{
	PARSING_NOTHING,

	PARSING_TEXT,

	PARSING_TAG_NAME, 
	PARSING_TAG_ATTRIBUTE,
	PARSING_TAG_ATTRIBUTE_NAME,
	PARSING_TAG_ATTRIBUTE_NAME_OR_VALUE,
	PARSING_TAG_ATTRIBUTE_VALUE,
	PARSING_COMMENT,
	
	PARSING_ENDTAG

};

enum READSTATE
{
	READING_NOTHING,
	READING_TEXT,
	READING_TITLE
};

//Types of block level elements
enum BLOCKTYPE
{
	eBlock_none,
	eBlock_p,
	eBlock_table,
	eBlock_form
};

class CTag;

class CTag
{
public:
	CTag();
	~CTag();
	void Clear();

    typedef std::map<std::string, std::string> Map;
    std::string name;
    Map attributes;

	std::string text;

    typedef std::list<CTag*> List;
    std::list<CTag*> ChildList;
};

#define DTD_FLAG_CONTAINS_TEXT	1

struct DTD_TABLE_ENTRY
{
	char szParent[MAX_TAG_NAME_LENGTH];
	char szChild[MAX_TAG_NAME_LENGTH];
	unsigned int uFlags;
};

class CTagParser  
{
public:
	bool ParseFile(char* szFilename);
    bool ParseText( const _TCHAR* text );
	CTagParser();
	~CTagParser();
    std::list<CTag*>& GetTagList() 
		{return _RootTag.ChildList;}

	bool SetTagRelationships(DTD_TABLE_ENTRY* pDocTypeDefTable, unsigned int iNumEntries);

protected:
	void Prepare();
	void Cleanup();
/*	void CommonBeginBlockBehaviour();
	void EndCurrentBlock();
	void HandleBeginTag_p();
	void HandleBeginTag_body();
	void ReportError(CString strMessage);*/
	void ProcessBeginTag();
	void ProcessEndTag();
	void BeginParseState(PARSESTATE NewParseState);
	void ProcessTag();
	void EndBeginTag();
	void ParseTagAttributeNameOrValue(char cChar);
	void ParseTagAttributeValue(char cChar);
	void ParseTagAttributeName(char cChar);
	void ParseTagName(char cChar);
	void BeginNewTag();
	bool ParseCharacter(char cChar);
	void ParseText(char cChar);

	bool CanTagHaveChild(char* pszParent, char* pszPotentialChild);
	bool TagStoresText(const char* pszTagName);
	bool IsTagContainer(const char* pszTagName);
	READSTATE ReadState;
	PARSESTATE ParseState;

	char szCurrent[5000];
	CTag* _pPotentialTag;
	CTag* _pCurrentTag;

	CTag _RootTag;
    std::list<CTag*> _TagStack;

	DTD_TABLE_ENTRY* pDTD_Table;
	unsigned int iDTD_TableSize;
	
	//char szTagName[MAX_TAG_NAME_LENGTH];
	char szTagAttributeName[MAX_TAG_ATTRIBUTE_NAME_LENGTH];
	char szTagAttributeValue[MAX_TAG_ATTRIBUTE_VALUE_LENGTH];

	bool bReadingComment;
	bool bFoundPrintableChar;
	bool bTagAttributeValueInQuotes;
	char cQuote;

	bool _bStoresText;
};

