#pragma warning(disable:4786)
#include <assert.h>
#include <stdio.h>
#include <iostream>
#include "Trace.h"
#include "Thread.h"
#include <tstring>
#include "debug.h"
#include <tstring>
#include <iostream>

using namespace std;

Trace trace;

void endl(Trace& object)
{
	object.nextline();
}

Trace::Trace()
{
	construct();
}

void Trace::construct()
{
	_enabled = true;
	_mutex = new Mutex;
	_output = 0;
}

Trace::~Trace()
{
	flush();
	delete _mutex;
}

void Trace::enable_all()
{
  _enabledGroups.empty();
  _enabled = true;
}

void Trace::enable(const _tstring& group) 
{
  _enabledGroups.insert(group);
  _enabled = true;
}

void Trace::disable_all()
{
	_enabled = false;
}

void Trace::setLength(int lines)
{
	assert(lines >= 0);
	_backtrace = lines;
}

void Trace::setOutput(TraceOutput* output)
{
  Mutex::Scope lock(*_mutex);
  _output = output;
} 

void Trace::nextline(bool lock)
{
	if(!_enabled) {
	  _current = _T("");
	  return;
	}
	
	if ( lock ) {
	  _mutex->lock(DBG);
	}

	if ( _output ) {
	  _output->sendString(_current);
	} else {
	  _tcerr << _current << std::endl;
	}

	_current = _T("");
	if ( lock ) {
	  _mutex->unlock(DBG);
	}
}

void Trace::nextline(const std::_tstring& label)
{
  Mutex::Scope lock(*_mutex);
  _current = label + _T(": ") + _current;
  if ( _enabledGroups.empty() || _enabledGroups.find(label) !=
       _enabledGroups.end() ) {
    nextline(false);
  } else {
    _current = _T("");
  }
}

void Trace::flush()
{
}

TraceLabel::TraceLabel(const std::_tstring& text) :
  _label(text)
{
    _debug = this;
}

TraceLabel::~TraceLabel()
{
  _debug = 0;
}

void
TraceLabel::assertValid()
{
  assert(_debug == this);
}

void
TraceLabel::label( const std::_tstring& text ) {
  _label = text;
}

Trace& Trace::operator<<(const _TCHAR* text)
{
	Mutex::Scope lock(*_mutex);
	_current += text;
	return *this;
}

Trace& Trace::operator<<(const std::_tstring& text)
{
	Mutex::Scope lock(*_mutex);
	_current += text;
	return *this;
}

Trace& Trace::operator<<(int value)
{
	Mutex::Scope lock(*_mutex);
	_TCHAR buffer[20];
	_stprintf(buffer, _T("%d"), value);
	_current += buffer;
	return *this;
}

Trace& Trace::operator<<(unsigned long value)
{
	Mutex::Scope lock(*_mutex);
	_TCHAR buffer[20];
	_stprintf(buffer, _T("%ld"), value);
	_current += buffer;
	return *this;
}

Trace& Trace::operator<<(void (*manip)(Trace&))
{
	manip(*this);
	return *this;
}

Trace& Trace::operator<< (void* ptr)
{
	Mutex::Scope lock(*_mutex);
	_TCHAR buffer[20];
	_stprintf(buffer, _T("%p"), ptr);
	_current += buffer;
	return *this;
}


TraceLabel& TraceLabel::operator<<(const std::_tstring& text) 
{ 
  trace << text;
  return *this; 
}

TraceLabel& TraceLabel::operator<<(const _TCHAR* text) { 
  trace << text;
  return *this;
}

TraceLabel& TraceLabel::operator<<(int value) { 
  trace << value;
  return *this;
}

TraceLabel& TraceLabel::operator<<(unsigned long value) { 
  trace << value;
  return *this;
}

TraceLabel& TraceLabel::operator<< ( void (*manip)(Trace&) ) { 
  assertValid();
  if ( manip == ::endl ) trace.nextline(_label);
  return *this;
}

TraceLabel& TraceLabel::operator<< (void* ptr) { 
  trace << ptr;
  return *this; 
}


