#ifndef WIDE_H
#define WIDE_H
#include <stdlib.h>

/**
  The WideChar class provides a quick way to convert a wide character string
  to a multibyte string, without worrying about allocating a buffer.
  See NarrowChar to do the opposite.

  Example:

  \code
  char title = "hello";
  SetWindowTitleW( hwnd, WideChar(title) );
  \endcode
*/

class WideChar
{
public:
    WideChar( const char* text );
    WideChar( const wchar_t* text );
    ~WideChar();

    operator const wchar_t*() const;
private:
    wchar_t* _text;
};

/**
  The NarrowChar class provides a quick way to convert a multibyte character
  string to a wide string, without worrying about allocating a buffer.
  See WideChar to do the opposite.
*/

class NarrowChar
{
public:
    NarrowChar( const char* text );
    NarrowChar( const wchar_t* text );
    ~NarrowChar();
    operator const char*() const;
private:
    char* _text;
};


#endif // WHITE_H
