#ifndef CLIST_H
#define CLIST_H
typedef struct _list_entry_t {
    struct _list_entry_t* next;
    struct _list_entry_t* prev;
} list_entry_t;
#define list_init( entry ) \
    (entry)->prev = (entry)->next = entry
#define container_of( ptr, type, member ) \
    ((type *)((char *)(ptr)-(unsigned long)(&((type *)0)->member)))
#define list_entry( ptr, type, member )\
    container_of(ptr, type, member)
#define list_empty( list ) \
    ((list)->next == (list))
#define list_head( list ) \
    (list)->next
#define list_add_tail( list, entry ) \
    (entry)->next = (list); \
    (entry)->prev = (list)->prev; \
    (list)->prev->next = (entry); \
    (list)->prev = (entry) 
#define list_remove( entry ) \
    assert( (entry)->next != 0 ); \
    (entry)->prev->next = (entry)->next; \
    (entry)->next->prev = (entry)->prev;
#endif // CLIST_H
