#include "rc4.h"
#include <stdlib.h>

/**
 * Create Rc4Encoder object.
 * @param dkey Pointer to the key (which may contain null characters).
 * @param keylen The length of the key. The length may be from 1 to 256
 * characters.
 */
Rc4Encoder::Rc4Encoder( const char* dkey, unsigned keylen )
{
    int j;
    int i;
    unsigned char temp;
    const unsigned char* key = (const unsigned char*)dkey;
    _sbox = (unsigned char*)malloc(256);

    for( i = 0; i <= 255; i++ ) {
        _sbox[i] = i;
    }

    j = 0;
    for( i = 0; i <= 255; i++ ) {
        j = (j + _sbox[i] + key[ i % keylen ] ) % 256;
        temp = _sbox[i];
        _sbox[i] = _sbox[j];
        _sbox[j] = temp;
    }
}

Rc4Encoder::~Rc4Encoder()
{
    free( _sbox );
    _sbox = 0;
}

/**
 * Cipher some text using the rc4 algorithm.
 */
void
Rc4Encoder::crypt( char* ddata, unsigned datalen )
{
    unsigned char* data = (unsigned char*)ddata;
    unsigned i;
    unsigned j;
    unsigned t;
    unsigned char temp;

    i = 0;
    j = 0;

    while( datalen-- ) {
        i = ( i + 1 ) % 256;
        j = ( j + _sbox[i]) % 256;
        temp = _sbox[i];
        _sbox[i] = _sbox[j];
        _sbox[j] = temp;

        t = ( _sbox[i] + _sbox[j] ) % 256;

        *data = *data ^ _sbox[t];
        data++;
    }
}
