#ifndef _WIN95_H
#define _WIN95_H

#include <windows.h>

/**
This version of the win32 function works on windows 95.
*/
BOOL WINAPI SafeGetLongPathName( LPCTSTR, LPTSTR, DWORD );

/**
This version of the win32 function works on windows 95. When not 
supported by the operating system, it chooses the middle colour and does
a solid fill.
*/
BOOL SafeGradientFill( IN HDC, IN PTRIVERTEX, IN ULONG, IN PVOID, IN ULONG, 
        IN ULONG);

/**
This version of the win32 function works on windows 95. When not 
supported by the operating system, it does not do the blend, but
simply does a BitBlt.
*/
BOOL SafeAlphaBlend(
  HDC hdcDest,                 // handle to destination DC
  int nXOriginDest,            // x-coord of upper-left corner
  int nYOriginDest,            // y-coord of upper-left corner
  int nWidthDest,              // destination width
  int nHeightDest,             // destination height
  HDC hdcSrc,                  // handle to source DC
  int nXOriginSrc,             // x-coord of upper-left corner
  int nYOriginSrc,             // y-coord of upper-left corner
  int nWidthSrc,               // source width
  int nHeightSrc,              // source height
  BLENDFUNCTION blendFunction  // alpha-blending function
);


#endif // _WIN95_H
