
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#ifndef DRAWTOOL_H
#define DRAWTOOL_H

#include "BaseWnd.h"
#include "SmartRef.h"

class ScalogramViewWindow;;

/**
 * Class to make tracking mouse dragging easier. It translates mouse event
 * messages into calls to onDragStart(), onDragStop(), and onDragAborted().
 */
class DragHandler
{
public:
    DragHandler();
    virtual ~DragHandler();

	virtual LRESULT processMessage(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

    bool dragging();
    POINT getDragStartPoint();
    POINT getDragReleasePoint();
    virtual void onDragStart( int x, int y );
    virtual void onDragStop( int x, int y );
    virtual void onDragAborted();
    virtual void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    virtual void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    virtual void onRButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    virtual void onKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags);
    HWND hwnd;
protected:
    POINT _dragStart;
    POINT _dragStop;
private:
    bool _dragging;
};

/**
 * Base class for any drawing tool.
 */
class DrawTool : public DragHandler
{
public:
    DrawTool( ScalogramViewWindow* drawWindow );
    virtual ~DrawTool();

    virtual bool active();
    virtual void onDragAborted();
    virtual void onPaint(DeviceContext dc);

protected:
    ScalogramViewWindow* _drawWindow;

private:
};

typedef SmartRef<DrawTool> DrawToolRef;

/**
  * Allows you to highlight a box on the image. 
  */
class DrawBoxTool : public DrawTool
{
public:
    DrawBoxTool( ScalogramViewWindow* drawWindow );
    virtual ~DrawBoxTool();

    virtual bool active();
    virtual void onDragStart( int x, int y );
    virtual void onDragStop( int x, int y );
    virtual void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    virtual void onPaint( DeviceContext dc );
    virtual void onDragAborted();

private:
    void drawRect( DeviceContext dc, bool draw );
    RECT _rect;
    bool _drawn;
};

/**
  * Allows you to add new selections to the document.
  */
class DrawSelectionTool : public DrawTool
{
public:
    DrawSelectionTool( ScalogramViewWindow* drawWindow );
    virtual ~DrawSelectionTool();

    virtual bool active();
    virtual void onDragStart( int x, int y );
    virtual void onDragStop( int x, int y );
    virtual void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    virtual void onPaint( DeviceContext dc );
    virtual void onDragAborted();

private:
    void drawRect( DeviceContext dc, bool draw );
    RECT _rect;
    bool _drawn;
};


#endif // DRAWTOOL_H
