// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#ifndef PlayWaveformTask_H
#define PlayWaveformTask_H

#include "Task.h"
#include "Waveform.h"

class DibImage;

/**
  * Parameters for PlayWaveformTask.
  */
class PlayWaveformTaskParams 
{
public:
    /// SoundImage to play
    WaveformRef wave;
};

/**
  * The PlayWaveformTask will first reconstruct the sound from a rectangular region of
  * the wavelet transform, and then play it.
  *
  * \warning Make sure nothing else is playing before calling this, otherwise
  * there will be an instant crash.
  */
class PlayWaveformTask : public Task<PlayWaveformTaskParams>
{
public:
	PlayWaveformTask( TaskObserver* observer );
	virtual ~PlayWaveformTask();

private:	
    virtual void run( PlayWaveformTaskParams params );
};

#endif // PlayWaveformTask_H
