// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#ifndef ScalogramCreator_H
#define ScalogramCreator_H

#include "Task.h"
#include "ColourMap.h"
#include "SoundImage.h"
#include "Waveform.h"

class DibImage;

class ScalogramCreatorParams
{
public:
    /// The waveform.
    WaveformRef wave;

    /// The destination image.
    SoundImage* image;

    /// The smallest scale to render.
    double lowerScale;

    /// The largest scale to render.
    double upperScale;

    /// "Wave number". Higher means more frequency localization. Smaller means
    /// more time localization.
    double f0;

    /// Type of image to create when rendering to the Dib.
    SoundImage::ImageType type;

    /// Colour map to use when rendering to the DibImage.
    ColourMap map;

    /// DibImage to which to render on the fly.
    DibImage* dib;
};

/**
  * This task implements the Continuous Wavelet Transform. It transforms the
  * given Waveform into the given SoundImage. At the same time, it fills in a
  * DibImage with a visual representation on the fly.
  *
  * Please note that while the SoundImage is being filled in, it has no mmax or
  * mmin data. Therefore it should be rerendered when done using the
  * ScalogramRender task to obtain a true representation in the DibImage.
  * Otherwise, the upper part of the image will be overly emphasized.
  */
class ScalogramCreator : public Task<ScalogramCreatorParams>
{
public:
	ScalogramCreator( TaskObserver* observer );
	virtual ~ScalogramCreator();

protected:
    virtual void run( ScalogramCreatorParams params );

private:	
};


#endif // ScalogramCreator_H
