// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#include "ScalogramRender.h"
#include "dbg.h" // must be last

ScalogramRender::ScalogramRender( TaskObserver* observer ) :
    Task<ScalogramRenderParams>::Task( observer )
{

}

ScalogramRender::~ScalogramRender()
{

}

void
ScalogramRender::run( ScalogramRenderParams params )
{
    int start = GetTickCount();
    SoundImageReader* reader = params.image->createReader();
    for ( int i = 0; i < (int)params.image->bands; i++ ) {

        params.image->renderRowToDib( i, params.dib, params.type, params.map,
            0, params.length, reader->getRow( i, params.offset, params.length ) );
        
        if ( GetTickCount() - start > 500 ) {
            setProgress( (double)i/params.image->bands );
            start = GetTickCount();
        }

        if ( _stopRequested  ) {
            break;
        }
    }

    delete reader;
}
