// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#ifndef ScalogramRender_H
#define ScalogramRender_H

#include "Task.h"
#include "ColourMap.h"
#include "SoundImage.h"

class DibImage;

class ScalogramRenderParams 
{
public:
    /// Image to render.
    SoundImage* image;

    /// Style of rendering (eg. logarithm, real, complex )
    SoundImage::ImageType type;

    /// Colour map to use.
    ColourMap map;

    /// Destination image.
    DibImage* dib;

    /// First sample to start at.
    unsigned offset;

    /// Number of samples to render.
    unsigned length;
};

/**
  * Renders the given scalogram to a DibImage.
  */
class ScalogramRender : public Task<ScalogramRenderParams>
{
public:
	ScalogramRender( TaskObserver* observer );
	virtual ~ScalogramRender();

private:	
    virtual void run( ScalogramRenderParams params );
};

#endif // ScalogramRender_H
