// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#ifndef ScalogramViewWindow_H
#define ScalogramViewWindow_H

#include "BaseWnd.h"
#include "ViewWindow.h"
#include "DrawTool.h"
#include "Task.h"
#include "SoundImage.h"
#include "DibImage.h"
#include "Events.h"
#include "Selection.h"

class ScalogramCreator;
class ScalogramRender;
class PlayTask;
class PlayWaveformTask;

/**
 * This child window contains the scalogram image. It also allows the user to
 * perform various actions on it through the use of the DrawTool classes.
 */
class ScalogramViewWindow : public ViewWindow, public TaskObserver, public
                            EventListener
{
public:
    ScalogramViewWindow(HINSTANCE);
    ~ScalogramViewWindow();

    void create(HWND hParent);
    virtual void setDoc( WaveletDocRef doc );
    void setViewExtents( int start, int end );
    void enhance();
    virtual void onEvent( unsigned event );

    void onDrawRect( RECT* rect );
    void setType( SoundImage::ImageType type );
    void setColourMap( unsigned index );

    SoundImage::ImageType getType();
    DibImageRef _dib;
    DibImageRef _enhanceDib;

    virtual void onTaskNotify( AbstractTask* );
protected:

private:
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);

    void onClose(HWND);
    void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
    BOOL onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct);
    void onDestroy(HWND hwnd);
    void onKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags);
    void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    void onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
    void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    void onPaint(HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient);
    void onSize(HWND hwnd, UINT state, int cx, int cy);
    void onChar(HWND hwnd, _TCHAR ch, int lParam );
    void drawSelection(DeviceContext dc);
    int transformX( int x );
    int transformY( int y );
    void transform( RECT* rect );
    int untransformX( int x );
    int untransformY( int y );
    void untransform( RECT* rect );
    void renderAgain();
    void removeEnhancement();

    HWND _hParent;

    /// The start of the viewed area, in samples.
    int _viewStart;

    /// The end of the viewed area, in samples.
    int _viewEnd;

    /// The current drawing tool in use.
    DrawToolRef _drawTool;

    /// The type of image (eg. log, real, complex, phase)
    SoundImage::ImageType _type;

    /// The ColourMap type used to render.
    unsigned _colourMapType;

    ScalogramCreator* _creatorTask;
    ScalogramRender* _renderTask;
    ScalogramRender* _enhanceTask;
    PlayWaveformTask* _playWholeFileTask;
    PlayTask* _playTask;
};

#endif // ScalogramViewWindow_H
