// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#ifndef WAVEFORM_H
#define WAVEFORM_H

#include <tstring>
#include "SmartRef.h"
#include <tchar.h>


class Waveform;

struct WaveInformation{
    unsigned sampleRate;
    unsigned size;
};

/**
  * This class is obsolete and unused.
  */
class WaveformObserver
{
public:
    virtual ~WaveformObserver();
    virtual void onWaveformChanged( Waveform* )=0;
};

/**
  * Contains a waveform loaded in from a sound file.
  */
class Waveform
{
public:
    Waveform();
    ~Waveform();

    static Waveform* load( const char* filename );
    static bool getFileInfo( const _TCHAR* filename, WaveInformation* info );
    bool save( const char* filename );
    void alloc( unsigned size );
    void clear( unsigned start, unsigned end );
    void clear();
    void normalize();
    double findMax();
    void scale( double factor );
    bool resample( unsigned rate);

    void setObserver( WaveformObserver* observer );
    void notifyChanged();

    unsigned sampleRate;
    unsigned size;
    std::_tstring name;

    double* samples;
private:
    // only one
    WaveformObserver* _observer;
};

typedef SmartRef<Waveform> WaveformRef;

#endif // WAVEFORM_H
