// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#ifndef WAVELET_APPLICATION_H
#define WAVELET_APPLICATION_H

/**
 @mainpage Wavelet Sound Explorer

 Please see http://gandolf.homelinux.org/~smhanov/wavelet

 Wavelet Sound Explorer is a program that takes a sound file and produces the
 continuous wavelet transform of that sound, and displays it on the screen.
 The goal is to allow audio editing in the frequency domain. That is, edits
 that apply only to certain frequencies.

 The SoundImage class manages memory allocation of the continuous wavelet
 transform. There are two types: A MemorySoundImage, which is completely
 contained in memory, and the DiskSoundImage, which can accomodate a
 multi-gigabyte file. Access to the SoundImage must be done at a row at a time.
 Fetching the data from disk using Overlapped disk access means it won't slow
 down processing.

 The user is never presented with the complete wavelet transform -- it would be
 too huge. Instead, SoundImage::renderToDib() renders the image one row at a
 time to a Windows Device Independent Bitmap. The bitmap is much smaller, so
 some information is lost. That's okay,because this preview image is just for
 display.
 

 The ScalogramCreator class represents a new thread, so we can calculate the
 wavelet transform and still allow the user to do other things. It simply
 convolves scaled versions of the wavelet with the Waveform and calles
 SoundImage::renderToDib().

 The ScalogramViewWindow draws the Device Independent Bitmap to the screen. It
 manages various tasks -- the ScalogramCreator and the ScalogramRenderer. Along
 with the preview image created by the ScalogramCreator, it also maintains an
 Enhanced Dib. If the user zooms into a particular section, the small preview
 image might be too blurry. So the ScalogramViewWindow immeidately starts the
 ScalogramRender task to produce only the visible section of the wavelet
 transform, at full resolution.
 
 The ScalogramViewWindow also has a DrawTool, of which there is one instance at
 at time. The DrawTool implements various mouse-oriented functions, like
 drawing a selection, etc.

 The PlayTask is invoked when the user highlights a region of the image. It
 performs the inverse continuous wavelet transform of that portion, and then
 outputs it to the sound card.

 */

#include "BaseWnd.h"
#include <list>
#include "Events.h"

class MainWindow;

/**
 * Main application class. It's purpose is to parse command line arguments and 
 * create the main window.
 */ 
class WaveletApplication : public BaseApplication
{
public:
	WaveletApplication(HINSTANCE);
	virtual ~WaveletApplication();

    virtual bool initialize( const TCHAR* lpszCommandLine );
    virtual void uninitialize();

    void openWebPage();
    void quit();
    void install(bool bInstall);

    MainWindow* _mainWindow;

private:

};

extern WaveletApplication* _application;

#endif
