// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#include "Waveform.h"
#include "WaveletDoc.h"
#include "SoundImage.h"
#include "dbg.h" // must be last


WaveletDoc::WaveletDoc( WaveformRef wave, SoundImage* image )
{
    undoStack = new UndoStack(this, 100);
    name = "Empty Wavelet";
    this->wave = wave;
    this->scalogram = image;
}

WaveletDoc::WaveletDoc(WaveletDoc& other)
{
    undoStack = new UndoStack(this, 100);
}

WaveletDoc::~WaveletDoc()
{
    delete scalogram;
    delete undoStack;
}

void 
WaveletDoc::undoRedo( UndoRecord* record, bool redo )
{
    WaveletAction* action = dynamic_cast<WaveletAction*>(record);
    action->execute( this, redo );
}

WaveletDoc* 
WaveletDoc::open( const char* filename )
{
    Waveform* wave = Waveform::load( filename );

    if ( wave == 0 ) {
        return NULL;
    }

    SoundImage* image = new MemorySoundImage();
    if ( !image->alloc( wave->size, wave->sampleRate ) ) {
        delete image;
        delete wave;
        return NULL;
    }

    wave->normalize();

    WaveletDoc* doc = new WaveletDoc( wave, image );
    doc->name = filename;
    return doc;
}

WaveletAction::WaveletAction( const _TCHAR* description ) :
    UndoRecord( description )
{
}

AddRectSelAction::AddRectSelAction( RECT rect ) :
    UndoRecord( _T( "Add Selection" ) ),
    rect( rect )
{
}

void 
AddRectSelAction::execute( WaveletDoc* doc, bool redo )
{
    if ( redo ) {
        doc->selection.rects.push_back( rect );
    } else {
        doc->selection.rects.pop_back();
    } 
}

RemoveRectSelAction::RemoveRectSelAction( int index ) :
    UndoRecord( _T( "Delete Selection" ) ),
    index( index )
{
}

void 
RemoveRectSelAction::execute( WaveletDoc* doc, bool redo )
{
    if ( redo ) {
        rect = doc->selection.rects[index];
        doc->selection.rects.erase( doc->selection.rects.begin()+index );
    } else {
        doc->selection.rects.insert( doc->selection.rects.begin()+index, rect );
    } 
}

ModifyRectSelAction::ModifyRectSelAction( int index, RECT rect ) :
    UndoRecord( _T( "Change Selection" ) ),
    index( index ), 
    rect( rect )
{
}

void 
ModifyRectSelAction::execute( WaveletDoc* doc, bool redo )
{
    if ( redo ) {
        backup = doc->selection.rects[index];
        doc->selection.rects[index] = rect;
    } else {
        doc->selection.rects[index] = backup;
    } 
}


