// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#ifndef WAVELETDOC_H
#define WAVELETDOC_H

#include "UndoStack.h"
#include <string>
#include "Waveform.h"
#include "SmartRef.h"
#include "Selection.h"

class WaveletDoc;
class SoundImage;

/**
  * Base class for all actions that can be undone.
  */
class WaveletAction : public UndoRecord
{
public:
    WaveletAction( const _TCHAR* description );
    virtual void execute( WaveletDoc* doc, bool redo )=0;
};

/**
  * Adds a rectanglular region to the selection.
  */
class AddRectSelAction : public UndoRecord
{
public:
    AddRectSelAction(RECT rect);
    void execute( WaveletDoc* doc, bool redo );
    RECT rect;
};

/**
  * Deletes a rectanglular region from the selection.
  */
class RemoveRectSelAction : public UndoRecord
{
public:
    RemoveRectSelAction(int index);
    void execute( WaveletDoc* doc, bool redo );
    int index;
    RECT rect;
};

/**
  * Changes a rectanglular region in the selection.
  */
class ModifyRectSelAction : public UndoRecord
{
public:
    ModifyRectSelAction(int index, RECT rect);
    void execute( WaveletDoc* doc, bool redo );
    int index;
    RECT rect;
    RECT backup;
};

/**
  * Represents a Wavelet document, consisting of a Waveform, a SoundImage, and
  * a Selection.
  */
class WaveletDoc : public UndoClient
{
public:
    WaveletDoc( WaveformRef wave, SoundImage* image );
    WaveletDoc(WaveletDoc& other);
    virtual ~WaveletDoc();

    static WaveletDoc* open( const char* filename );

    UndoStack* undoStack;

    virtual void undoRedo( UndoRecord* record, bool redo );

    std::string name;

    WaveformRef wave;
    SoundImage* scalogram;
    Selection selection;

private:
    friend class WaveletAction;
};

typedef SmartRef<WaveletDoc> WaveletDocRef;

#endif // WAVELETDOC_H
