#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "fftw3.h"

const double pi = 3.14159265358979323846;
const double divisor = 2.0*2*2*0.849*0.849;

double RealWavelet( double x )
{	
    // accoring to illustrated:
    // cos(pi*x)*exp(-x*x/2/(2.0*2*0.849))
    return pow(pi, -0.25) * 
         ( cos(pi*x) - exp(-(2*pi*0.849)*(2*pi*0.849)/2) ) *
         exp(-x*x/divisor);
}

double ImagWavelet( double x )
{	
     return pow(pi, -0.25) * 
         ( sin(pi*x) - exp(-(2*pi*0.849)*(2*pi*0.849)/2) ) *
         exp(-x*x/divisor);
}
float FTWavelet( float x, float scale)
{
    // Directly calculate the fourier transform of the wavelet.
    //pi^0.25*(exp(-0.5*(6+x)^2)-exp(-0.5*6^2)*exp(-0.5*x^2))
    //return (float)(FRT_PI * 
    //    ( exp( -0.5 * (sigma + x) * (sigma + x) ) -
    //      exp( -0.5 * sigma * sigma ) * exp( -0.5 * x * x ) ) );

    static const double f0 = 0.849;
    float basic;
    scale *= f0;
    basic = (float)(pow( (double)pi, 0.25 ) * sqrt(2.0) *
            exp(-0.5*(2*pi*x*scale-2*pi*f0)*(2*pi*x*scale-2*pi*f0)));

    // pi^0.25*sqrt(2.0)*exp(-0.5*(2*pi*x*scale-2*pi*0.849)^2)
    return sqrt(scale)*basic;
}

#define SWAP(a,b) tempr=(a);(a)=(b);(b)=tempr
#define SQR(a) ((a)*(a))
/****************************************************************************
    Replaces data[1..2*nn] by its discrete Fourier transform, if isign is input
    as 1; or replaces data[1..2*nn] by nn times its inverse discrete Fourier
    transform, if isign is input as -1.  data is a complex array of length nn
    or, equivalently, a real array of length 2*nn. nn MUST be an integer power
    of 2 (this is not checked for!).

    Note 1: array begins at index 1, so you have to call it with 
           four1( data-1, nn, isign)

    Note 2: Array is in wraparound order.

    Note 3: Array contains nn complex numbers, each of which takes two elements.

 ****************************************************************************/   
void four1(double data[], unsigned long nn, int isign)
{
    unsigned long n,mmax,m,j,istep,i;
    // Double precision for the trigonometric recurrences. 
    double wtemp,wr,wpr,wpi,wi,theta; 
    double tempr,tempi;
    n=nn << 1;
    j=1;

    for (i=1;i<n;i+=2) { 
        // This is the bit-reversal section of the routine. 
        if (j > i) {
            SWAP(data[j],data[i]); //Exchange the two complex numbers.
            SWAP(data[j+1],data[i+1]);
        }
        m=nn;
        while (m >= 2 && j > m) {
            j -= m;
            m >>= 1;
        }
        j += m;
    }

    // Here begins the Danielson-Lanczos section of the routine.
    mmax=2;
    while (n > mmax) { //Outer loop executed log2 nn times.
        istep=mmax << 1;
        // Initialize the trigonometric recurrence.
        theta=isign*(6.28318530717959/mmax); 
            wtemp=sin(0.5*theta);
        wpr = -2.0*wtemp*wtemp;
        wpi=sin(theta);
        wr=1.0;
        wi=0.0;
        for (m=1;m<mmax;m+=2) { // Here are the two nested inner loops.
            for (i=m;i<=n;i+=istep) {
                j=i+mmax; //This is the Danielson-Lanczos formula:
                tempr=(double)(wr*data[j]-wi*data[j+1]);
                tempi=(double)(wr*data[j+1]+wi*data[j]);
                data[j]=data[i]-tempr;
                data[j+1]=data[i+1]-tempi;
                data[i] += tempr;
                data[i+1] += tempi;
            }
            wr=(wtemp=wr)*wpr-wi*wpi+wr; //Trigonometric recurrence.
            wi=wi*wpr+wtemp*wpi+wi;
        }
        mmax=istep;
    }
}

int round_2_up(int num)
{
    return (int)pow( 2, ceil(log((double)num)/log((double)2)) );
}

int main(int argc, const char* argv[])
{
    // max frequency
    const double sampleRate = 44100;

    // minimum scale
    const double minScale = 16;//2.0;
    const double maxScale = 16;// sampleRate/20;
    const double extent = 7.0;
    double period;
    int i;
    FILE* file;
    fftwf_plan plan_forward;
    fftwf_plan plan_inverse;
    fftwf_complex* ans;

    int size = round_2_up( 2*maxScale*extent*2*2*2 );
    if ( size < 512 ) {
        size = 512;
    }
    ans = (fftwf_complex*)fftwf_malloc(size*sizeof(fftwf_complex));
    plan_forward = fftwf_plan_dft_1d(size, ans, ans, FFTW_FORWARD,
            FFTW_ESTIMATE );
    plan_inverse = fftwf_plan_dft_1d(size, ans, ans, FFTW_BACKWARD,
            FFTW_ESTIMATE );

    for( period = minScale; period <= maxScale; period++ ) {
        memset( ans, 0, sizeof(fftwf_complex)*size);
        if ( 0 ) {
            for( i = 0; i < size/4; i++ ) {
                ans[i][0] = RealWavelet( (float)i/period );
                ans[i][1] = ImagWavelet( (float)i/period );;
                ans[size-1-i][0] = RealWavelet((float)-i/period);
                ans[size-1-i][1] = ImagWavelet((float)-i/period);
            }

            //four1(ans-1, size/2, 1);
            fftwf_execute( plan_forward );
        } else {
            for( i = 0; i < size/2; i++ ) {
                ans[i][0] = FTWavelet( (float)i, period/(size/2));
                ans[size-1-i][0] = FTWavelet((float)-i, period/(size/2));
            }

            //four1(ans-1, size/2, -1);
            fftwf_execute( plan_inverse );
        }


        printf("%g\r", period);
        file = fopen( "out.txt", "wt");
        for( i = 0; i < size; i++ ) {
            fprintf(file, "%g\n", ans[i][0]);
        }
        fclose( file );
    }

    free( ans );
    return 0;
}


