# Moscat: Mixture of Scope Experts at Test

Code repository for paper: 
_Mixture of Scope Experts at Test: Generalizing Deeper Graph Neural Networks with Shallow Variants_

## ⚙️ Setup

Ensure your environment meets the following dependencies (newer versions might also work):

- Python 3.11.4
- PyTorch 2.0.1
- torch_geometric 2.4.0
- torch-scatter 2.1.2
- torch-sparse 0.6.18
- hydra-core 1.3.2
- hydra-colorlog 1.2.0
- torchmetrics 0.11.4
- class_resolver 0.4.3

## 🚀 Launching Moscat

All configuration files are available in the `conf` directory to help reproduce the results reported in Table 1 (Main Results) and Table 7 (Leaderboard Comparison).

 > **Note:** You can adjust the logging verbosity by setting `log_level=INFO` (default) for more detailed logs or `log_level=CRITICAL` for minimal logging output.

### 1. Train GNN Scope Experts (Scope 0 to 6)

- **0-hop MLP Scope Expert:**
    ```shell
    python run_gnn.py -m +exp_gnn=penn94_mlp log_logit=true  
    ```

- **1-6 hop GNN Scope Experts:**
    ```shell
    python run_gnn.py -m +exp_gnn=penn94_gcn model.conv_layers=1,2,3,4,5,6 log_logit=true
    ```

### 2. Train the Moscat Gating Model
```shell
python run_moscat.py +exp_moscat=penn94_gcn
```