from pathlib import Path

from datasets import load_dataset


def load_and_save_dataset_hf(path: str, name: str, split: str, filename: Path) -> None:
    """
    Downloads a dataset from the Hugging Face library and saves it in CSV format.

    Args:
        path (str): The path to the dataset in the Hugging Face library.
        name (str): The name of the dataset.
        split (str): Part of the dataset to download (for example, "train", "test").
        filename (Path): The path to save the file in CSV format.

    Returns:
        None
    """
    try:
        # Download the dataset and convert it to a Pandas DataFrame
        df = load_dataset(path, name=name, split=split).to_pandas()

        # Make sure that the directory for saving the file exists
        filename.parent.mkdir(parents=True, exist_ok=True)

        # Save DataFrame to CSV
        df.to_csv(filename, index=False)
        print(f"Dataset is saved to: {filename}")

    except Exception as e:
        print(f"Error loading or saving the dataset: {e}")


def main() -> None:
    """
    The main function for downloading and saving the ethics dataset.
    """
    # Path to save
    ethics_path = Path("data/ethics")

    # Dataset list to load
    dataset_names = ["per_ethics", "sit_ethics"]

    # A loop for loading and saving each dataset
    for name in dataset_names:
        load_and_save_dataset_hf(
            path="RussianNLP/tape",
            name=f"{name}.raw",
            split="train",
            filename=ethics_path / f"{name}.csv",
        )


if __name__ == "__main__":
    main()
