from pathlib import Path

from datasets import load_dataset


def load_and_save_dataset_hf(path: str, name: str, split: str, filename: Path) -> None:
    """
    Downloads a dataset from the Hugging Face library and saves it in CSV format.

    Args:
        path (str): The path to the dataset in the Hugging Face library.
        name (str): The name of the dataset configuration.
        split (str): Part of the dataset to download (for example, "train", "test").
        filename (Path): The path to save the file in CSV format.
    Returns:
        None
    """
    try:
        # Download the dataset and convert it to a Pandas DataFrame
        dataset = load_dataset(path, name=name, split=split)
        df = dataset.to_pandas()

        # Make sure that the directory for saving the file exists.
        filename.parent.mkdir(parents=True, exist_ok=True)

        # Save DataFrame to CSV
        df.to_csv(filename, index=False)
        print(f"Dataset is saved to:  {filename}")

    except Exception as e:
        print(f"Error loading or saving the dataset: {e}")


def main() -> None:
    """
    The main function for downloading and saving the dataset MERA (ruhatespeech).
    """
    # Path to save
    data_path = Path("path_to_project/TrustLLM_ru/data/ruhatespeech")

    # Config name
    dataset_name = "ruhatespeech"

    # Load and save
    load_and_save_dataset_hf(
        path="MERA-evaluation/MERA",
        name=dataset_name,
        split="test",
        filename=data_path / f"{dataset_name}.csv",
    )


if __name__ == "__main__":
    main()
