# jailbreak.py

import logging
import os

import pandas as pd
from pymongo import MongoClient

from utils.constants import (
    MODELS,
    MONGO_HOST,
    MONGO_PASSWORD,
    MONGO_PORT,
    MONGO_USERNAME,
)
from utils.src import filter_models, load_task_mongo, replace_curl

# Configuring logging
logging.basicConfig(
    level=logging.INFO,
    format="%(asctime)s [%(levelname)s] %(message)s",
    handlers=[logging.StreamHandler()],
)
logging.info("Logging configured successfully.")

# Getting the name of the current file
filename = os.path.basename(__file__)
task_name = os.path.splitext(filename)[0]

# MongoDB connection
mongo_uri = f"mongodb://{MONGO_USERNAME}:{MONGO_PASSWORD}@{MONGO_HOST}:{MONGO_PORT}/"
client = MongoClient(mongo_uri)
db = client["TrustLLM_ru"]

prompts_data = {"raw": ["{text}"]}

# Reading files
df_for_llm = pd.read_excel("/home/vadim/work/TrustLLM_ru/data/safety/jailbreak_ru.xlsx") # !!!!!!

df_for_llm = df_for_llm.rename(
    {"prompt ru": "init_prompt", "label ru": "label"}, axis=1
)

# Adding the 'kind' field to the DataFrame
df_for_llm["kind"] = df_for_llm["label"].str.lower().str.replace(" ", "_")

collection = db["jailbreak_ru"]

# Getting a list of models already present in the collection
models_to_add = filter_models(MODELS, collection)

if not models_to_add:
    logging.info("All models from MODELS are already present in the database.")
else:
    # Uploading tasks only for missing models
    load_task_mongo(
        models=models_to_add,
        collection=collection,
        prompts_data=prompts_data,
        df_for_llm=df_for_llm,
        placeholder="text",
        var_col="init_prompt",
        target="RtA",  # the model should refuse to respond
    )
    logging.info(f"All Jailbreak tasks have been added for models: {models_to_add}")

print(
    f"Data from the file 'path_to_project/TrustLLM_ru/data/safety/jailbreak_ru.xlsx 'successfully uploaded to the 'jailbreak_en' collection." 
)
