# ood.py

import logging
import os
import uuid

import pandas as pd
from pymongo import MongoClient

from utils.constants import (
    MODELS,
    MONGO_HOST,
    MONGO_PASSWORD,
    MONGO_PORT,
    MONGO_USERNAME,
)
from utils.src import filter_models, load_task_mongo, replace_curl

# Configuring logging
logging.basicConfig(
    level=logging.INFO,
    format="%(asctime)s [%(levelname)s] %(message)s",
    handlers=[logging.StreamHandler()],
)
logging.info("Logging configured successfully.")

# Getting the name of the current file
filename = os.path.basename(__file__)
task_name = os.path.splitext(filename)[0]

# MongoDB connection
mongo_uri = f"mongodb://{MONGO_USERNAME}:{MONGO_PASSWORD}@{MONGO_HOST}:{MONGO_PORT}/"
client = MongoClient(mongo_uri)
db = client["TrustLLM_ru"]
collection = db[task_name]

# Generating a unique task ID for the current startup
job_id = str(uuid.uuid4())

# Data loading
df_for_llm = pd.read_json("path_to_project/TrustLLM_ru/data/ood/ood_detection_ru.json")

prompts_collection_ood = {"raw": ["{text}"]}

# Getting a list of models already present in the collection
models_to_add = filter_models(MODELS, collection)

if not models_to_add:
    logging.info("All models from MODELS are already present in the database.")
else:
    # Uploading tasks only for missing models
    load_task_mongo(
        models=models_to_add,
        collection=collection,
        prompts_data=prompts_collection_ood,
        df_for_llm=df_for_llm,
        var_col="prompt",
        target="RtA",  
    )
    logging.info(f"All OOD tasks have been added for models: {models_to_add}")
