# Structure-preserving contrastive learning for spatial time series

## Dependencies

To install the necessary dependencies, please run the following command:
```sh
pip install -r requirements.txt
```

## Steps to Reproduce the Experiments

- Step 0: Initial Setup
    - Please ensure that all required dependencies are installed as mentioned above.
    - Place the datasets in the `datasets/` directory. Due to size limitations, we are unable to include all datasets, but we have provided the "Handwriting" dataset in the `datasets/UEA/` directory for a simplified test.

- Step 1: Test the Environment
    - Kindly run the `environment_test.py` script to confirm that your environment is set up correctly. This script will test the necessary imports and random seed initialization, which are important for ensuring reproducibility. 
    - The printed random values should ideally match those in the script's comments. If there is any discrepancy, please verify that the random values remain consistent across repeated runs.

- Step 2: Precompute Distance Matrices 
    - You can precompute the distance matrices for the datasets by executing the `precompute_distance.py` script. The computed distance matrices will be stored in the corresponding directories where the datasets are located.

- Step 3: Hyperparameter Tuning 
    - To perform hyperparameter tuning, please run the `search_hyperparameters.py` script. The tuned hyperparameters will be saved in the `results/hyper_parameters/` directory. 
    - Tuning takes time because each dataset needs 57 runs to search for good parameters for all models, as shown at the beginning of the script. For your convenience, we have also provided these hyperparameters in this supplementary material.

- Step 4: Model Training and Evaluation 
    - To train and evaluate the models, kindly execute the `evaluate.py` script. The trained models and their evaluation results will be saved in the `results/evaluation/` directory. The evaluation results are also available in the supplementary material.

__Note:__ Due to file size constraints, we are unable to provide all datasets in this material. However, to assist with initial testing, we have included all relevant files for the "Handwriting" dataset, such as the data, precomputed distance matrices, hyperparameters, and evaluation results. For a more comprehensive set of experiments, you are welcome to download additional datasets from the UEA archive, place them in the `datasets/UEA/` directory, and follow the steps outlined above.

## Visualization

For visualizing the results, please open and run the `figures/visual.ipynb` notebook. This notebook generates tables and plots based on the evaluation results and saves them in the `results/figures/` directory.