'''
This file is used to load the microscopic traffic data from the npz files.
The functions are adapted from the original paper's code.
'''

import numpy as np


def get_INT_dataset(setname, filenames=['train1', 'train2', 'train3', 'train4'], dataset_dir='datasets'):
    if setname == 'train':
        Trajectories = []
        for filename in filenames:
            data = np.load(f'{dataset_dir}/MicroTraffic/'+filename+'.npz', allow_pickle=True)
            Trajectories.append(data['trajectory'])
        Trajectories = np.concatenate(Trajectories, axis=0)
    else:
        data = np.load(f'{dataset_dir}/MicroTraffic/'+setname+'.npz', allow_pickle=True)
        Trajectories = data['trajectory']
    return Trajectories

