def get_attack_loss(attack_start, attack_length):
    return attack_start + 1


def find_attack_location(attack_start=0,attack_end=118,attack_length=10,num_seg=4):
    """
    attack_start: 可攻击的第一个位置，闭区间
    attack_end: 可攻击的最后一个位置，开区间
    attack_length: 攻击的序列长度
    num_seg: 一开始将“可攻击位置”序列划分为几段
    """
    total_length = attack_end - attack_start
    if total_length <= 10:
        best_loss = 0
        best_attack_index = None
        for attack_index in range(attack_start, attack_end):
            loss = get_attack_loss(attack_index,attack_length)
            if loss > best_loss:
                best_loss = loss
                best_attack_index = attack_index
        return best_attack_index, best_loss

    best_loss = 0
    best_attack_index = None
    best_seg_start = None
    best_seg_end = None
    
    # 正常情况下每个seg的长度
    normal_seg_length = total_length // num_seg
    for seg_index in range(num_seg):
        # 最后一段
        if seg_index == num_seg - 1:
            seg_length = attack_end - (seg_index * normal_seg_length + attack_start)
        else:
            seg_length = normal_seg_length
        seg_start = seg_index * normal_seg_length + attack_start
        seg_end = seg_start + seg_length
        # 选middle
        attack_index = (seg_start + seg_end-1)//2
        tmp_loss = get_attack_loss(attack_index, attack_length)
        if tmp_loss > best_loss:
            best_loss = tmp_loss
            best_attack_index = attack_index
            best_seg_start = seg_start
            best_seg_end = seg_end
    # 在新的一段上再去找
    attack_index, loss = find_attack_location(
        best_seg_start, 
        best_seg_end,
        attack_length,
        num_seg
    )
    if loss > best_loss:
        best_loss = loss
        best_attack_index = attack_index
    return best_attack_index, best_loss

