##Running

For running the code, you have to run the following command:

```python3 launcher.py <config-file-name>```

example:

```python3 launcher.py experiment1.yaml```

##YAML file content:
	name: name of your task, something as an explanation

	id: the ID that you assign to your task, will be used to as the 
	save path of your model/signature

	gpus: a list of gpus that you want to assign to your task

	pranc: parameters for pranc training

	pranc.seed: the seed for generating the basis networks

	pranc.num_alpha: number of alpha parameters

	pranc.window_size: m,k in the paper, the number of alphas used in coordinate descent

	pranc.lr: learning rate for pranc

	experiment: detail parameters of an experiment

	experiment.mode: indicates whether this experiment is a training or a testing task

	experiment.method: indicates the method used for this experiment. could be either normal for vanilla training/testing or pranc for pranc training/testing

	experiment.lr: learning rate which is used for vanilla training. will be ignored if training method is pranc

	experiment.epoch: number of epochs for an experiment

	experiment.batch_size: batch size for training

	experiment.resume: path to the file containing the pretrained signature/model for resuming training. signature path will be used for pranc and model path will be used in normal mode

	experiment.load_model: path to the file containing the pretrained signature/model for testing. signature path will be used for pranc and model path will be used in normal mode

	experiment.task: the task which is going to be solved. either cifar10, cifar100 or tiny

	experiment.model_arch: the model architecture used for this experiment. could be resnet20, resnet56, etc

	monitor: logging details

	monitor.log_rate: rate of logging based on number of epochs

	monitor.save_model: path to save trained model
	
	monitor.save_path: path to save signature (only when training in pranc mode)

