# ICLR 2022 Submission - Image Compression and Classification Using Qubits and Quantum Deep Learning

# About
Anonymous authors.

This repository contains the code for the experiments in  "Image Compression and Classification Using Qubits and Quantum Deep Learning"

# Reproducing the Experiments

## Dependencies

First, install the dependencies using `pip install -r requirements.txt`

Verify that your dependencies are installed correctly by running the tests: `python3 -m unittest tests.regression`

## Experiments

There are two ways to run the experiments:
### 1. Without splitting and serializing intermediate circuits:
    For 16 layers, 4 qubits with x2 compression (and parallelized circuit conversion)
    '''shell
    python3 run.py -l 16 -q 4 -x 2 -p
    '''
### 2. With splitting and serializing, for larger images and circuits:
    First convert and serialize the quantum tensors
    '''shell
    #!/bin/bash
    for i in {0..7}:
    do
        python3 run.py -l 16 -q 4 -x 2 -p -s 8 -i $i -w -p
    done
    '''
    Then run the training by reading the split serialized tensors
    '''shell
    python3 run.py -l 16 -q 4 -x 2 -s 8 -r
    '''
