import argparse
import json
def argument():
    parser = argparse.ArgumentParser("metric", add_help=False)
    parser.add_argument("--file_suffix", type=str, default='',
                        help="file suffix")
    
    parser.add_argument("--model", type=str, default='gpt3.5',
                        help="LM model type")
    parser.add_argument("--test_type", type=str, default='ip', choices=['ip','harm','privacy', 'all', 'example'], help='dataset type')
    
    parser.add_argument("--generation_blackbox", type=str, default='stable_diffusion1')

    parser.add_argument("--seed_prompt_model", type=str, default='llava')
    parser.add_argument('--seed_list', type=lambda a: json.loads('['+a.replace(" ",",")+']'), default="0 1 2", help="List of values")                                              
    parser.add_argument("--seed_automated",  action='store_true',
                        help="seed prompting automated or not version") 
    parser.add_argument("--seed_inst_optim_llm", type=str, default='llama3',
                        help="Seed prompt instruction otimzier LM model type")
    parser.add_argument("--seed_automated_strategy", type=str, default='ours',
                        help="Seed prompt optimzing type (opro, opt2i, ours)")
    parser.add_argument("--unchange_update_num", type=int, default=5,
                        help="Automated prompt tuning iteration number")                 
    parser.add_argument("--seed_cand_num", type=int, default=1,
                        help="Automated prompt revision number")  

    parser.add_argument("--rephrase_automated_strategy", type=str, default='ours',
                        help="Revise prompt optimzing type (opro, opt2i, ours)")
    parser.add_argument("--rephrase_cand_num", type=int, default=3,
                        help="Automated prompt revision number")  
    parser.add_argument("--rephrase_iter", type=int, default=3,
                        help="Rephrase iteration number")
    parser.add_argument("--num_rephrase", type=int, default=1,
                        help="Rephrased sentences number")
    parser.add_argument("--num_beams", type=int, default=10,
                        help="number of beams")

    parser.add_argument("--qa_ablation", type=int, default=1, help="qa type")
    parser.add_argument("--wo_qa", action="store_true")
    
    parser.add_argument("--deepspeed", action="store_true")
    parser.add_argument('--master_port', type=str, default="28900")

    parser.add_argument('--local_rank', type=int, default=0)
    
    parser.add_argument("--logging", action="store_true")
    
    # args for diffusion process
    parser.add_argument("--config", type=str, default="/compvis/configs/finetune.yaml",
                            help="path to config which constructs model")
    parser.add_argument("--ckpt", type=str, default='/dataset/copyright/sd-v1-4.ckpt',
                            help="path to checkpoint of the pre-trained model")
    parser.add_argument("--outdir", type=str, nargs="?",
                            help="dir to write results to",default="/./")
    parser.add_argument("--skip_grid", action='store_true',
                            help="do not save a grid, only individual samples. Helpful when evaluating lots of samples",)
    parser.add_argument("--skip_save", action='store_true',
                            help="do not save individual samples. For speed measurements.")
    parser.add_argument("--ddim_steps", type=int, default=100,
                            help="number of ddim sampling steps")
    parser.add_argument("--delta_ckpt", type=str, default=None,
                            help="path to delta checkpoint of fine-tuned custom diffusion block")
    parser.add_argument("--seed", type=int, default=42,
                            help="the seed (for reproducible sampling)")
    parser.add_argument("--ddim_eta", type=float, default=1.0,
                            help="ddim eta (eta=0.0 corresponds to deterministic sampling")
    parser.add_argument("--n_iter", type=int, default=1,
                            help="sample this often")
    parser.add_argument("--H", type=int, default=512,
                            help="image height, in pixel space")
    parser.add_argument("--W", type=int, default=512,
                            help="image width, in pixel space")
    parser.add_argument("--C", type=int, default=4,
                            help="latent channels")
    parser.add_argument("--f", type=int, default=8,
                            help="downsampling factor")
    parser.add_argument("--n_samples", type=int, default=1,
                            help="how many samples to produce for each given prompt. A.k.a. batch size")
    parser.add_argument("--n_rows", type=int, default=6,
                            help="rows in the grid (default: n_samples)")
    parser.add_argument("--scale", type=float, default=6.,
                            help="unconditional guidance scale: eps = eps(x, empty) + scale * (eps(x, cond) - eps(x, empty))")
    parser.add_argument("--chunk", action='store_true',
                            help="chunk + repeat prompts or not.")
    return parser.parse_args()

