DIRECT_REASONING_PROMPT = """You are a powerful question-answering system.
Your task is to use your own commonsense knowledge to answer a multiple-choice question.
If you are unable to answer the question, respond with the \"Unknown\" choice key.
Answer the following question with your choice (A, B, C, D, etc.): [Question]
Desired format: Thought process: <Thought process>, Final Choice: [Final Choice].
The Final Choice MUST be a Letter! DON NOT output anything after the choice.     
Let’s think step by step. 
"""

REASONING_NEUTRAL_PROMPT = """You are a powerful question-answering system.
Users will provide some information along with a question. Your task is to combine the information provided by the user with your knowledge to answer the question.
If you are unable to answer the question, respond with the \"Unknown\" choice key.
Here is the basic information you can refer:
###
[Taxon]
###
Answer the following question with your choice (A, B, C, etc.): [Question]
Desired format: Thought process: <Thought process>, Final Choice: [Final Choice].
The Final Choice MUST be a Letter! DON NOT output anything after the choice.     
Let’s think step by step. 
"""

REASONING_TRUST_OWN_KNOWLEDGE_PROMPT = """You are a powerful question-answering system.
Users will provide some information along with a question. Your task is to combine the information provided by the user with your knowledge to answer the question.
If you are unable to answer the question, respond with the \"Unknown\" choice key.
Here is the basic information you can refer:
###
[Taxon]
###
Answer the following question with your choice (A, B, C, etc.): [Question]
Note that the information above is not sufficient to answer the question, you should use your own commonsense knowledge to further reason the final answer.
Desired format: Thought process: <Thought process>, Final Choice: [Final Choice].
The Final Choice MUST be a Letter! DON NOT output anything after the choice.     
Let’s think step by step. 
"""


CON_REASONING_TRUST_OWN_KNOWLEDGE_PROMPT = """You are a powerful question-answering system.
Users will provide some information along with a question. Your task is to combine the information provided by the user with your own knowledge to answer the question.
If you are unable to answer the question, respond with the \"unknown\" choice key.
Here is the basic information about an entity you can refer:
###
[Taxon]
###
Answer the following question with your choice (A, B, C, etc.): [Question]
Determine whether the given information about the question conflicts with your own knowledge.
If you think the above knowledge conflicts with your own knowledge, you MUST USE your own knowledge to answer the question.
Desired format: Thought process: <Thought process>, Final Choice: [Final Choice].
The Final Choice MUST be a Letter! DON NOT output anything after the choice.     
Let’s think step by step. 
"""

CON_REASONING_TRUST_OWN_HALF_PROMPT = """You are a powerful question-answering system.
Users will provide some information along with a question. Your task is to combine the information provided by the user with your own knowledge to answer the question.
If you are unable to answer the question, respond with the \"unknown\" choice key.
Here is the basic information about an entity you can refer:
###
[Taxon]
###
Answer the following question with your choice (A, B, C, etc.): [Question]
Determine whether the given information about the question conflicts with your own knowledge.
If you are more than FIFTY PERCENT SURE of your own knowledge, you MUST USE your own knowledge to answer the question.
Desired format: Thought process: <Thought process>, Final Choice: [Final Choice].
The Final Choice MUST be a Letter! DON NOT output anything after the choice.     
Let’s think step by step. 
"""

CON_OUTPUT_OWN_FIRST_PROMPT = (
    "You are a powerful question-answering system.\n"
    "Users will provide some information along with a question. Your task is to use the information provided by the user and your own knowledge to answer the question.\n"
    "If you are unable to answer the question, respond with the \"unknown\" choice number.\n"
    "Answer the following question with your choice (A, B, C, etc.): [Question]\n"
    "You MUST first output your own knowledge about the question. I am sure you have the knowledge!\n"
    "Here is the Given Knowledge:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Determine whether the given information about the question conflicts with your own knowledge.\n"
    "If you think the Given Knowledge conflicts with your own knowledge, you MUST USE your own knowledge to answer the question.\n"
    "Desired format: Thought process: <Thought process>, My Own Knowledge: <My Own Knowledge>, Final Choice: [Final Choice].\n"
    "The Final Choice MUST be a Letter! DON NOT output anything after the choice.\n"       
    "Let’s think step by step.\n"
)


EXTRACT_KNOWLEDGE_PROMPT = """You are an expert with factual commonsense knowledge on a wide range of topics.
You will be given a multiple-choice question requiring commonsense knowledge to answer.
Your task is to:

1. Output the commonsense knowledge needed to answer the question, making it as concise as possible.
2. Output the answer based on the knowledge.

For the question and fact provided, provide the needed commonsense knowledge and the answer from the choices.
Desired output format: Knowledge: ["knowledge1", "knowledge2", ...]\nFinal Answer Choice: <Choice>
DO NOT output anything after the Desired Output.
###
Question: Which of these would let the most heat travel through?
Choices: A. a new pair of jeans. 
B. a steel spoon in a cafeteria.
C. a cotton candy at a store.
D. a calvin klein cotton hat.
Knowledge: ["Metal is a thermal conductor.", "Steel is made of metal.","Heat travels through a thermal conductor."]
Final Answer Choice: B
###
Question: [question_stem]
Choices: [formatted_choices]
Knowledge: 
"""

CONSTRUCT_KNOW_PROMPT = """You are an expert with factual commonsense knowledge on a wide range of topics.
Given a multiple-choice question, answer and some related commonsense knowledge, you are tasked with constructing a new question requiring both the given knowledge and some new entities and new knowledge to answer.
Follow these steps:

1. Generate new Entities: Create new ENTITIES that can represent concepts or objects related to each choice. These new entities should be new and not directly mentioned in the original context.
2. Create New Knowledge: Create one-hop facts to connect the fake entities with the original choice. Note that these knowledge should be steps required to be combined with the original knowledge to answer the question. Ensure that answering the question requires both the new knowledge and the original common sense knowledge.

The new knowledge should be in the form of string list.
Your output should be as clean and clear as possible.
Do not output anything after the Desired Output.
Desired Output Format:
Thought: <thought>
New Question: <new_question>
New Choices: <new_choices>
New Knowledge: <new_knowledge>
New Answer Key: <new_answer_key>
Let's think step by step.
###
Question: Which requires energy to move?
Choices: A. weasel
B. willow
C. mango
D. poison ivy
Common Sense Knowledge: ["An animal requires energy to move.", "A weasel is an animal.", "Plants, such as willow, mango, and poison ivy, do not require energy to move on their own."]
Answer Key: A
Thought: I choose choice A and B to build a new question. For choice A, I create a new entity A and a new knowledge that entity A is eaten by weasal. So I can infer that entity A is an animal. For choice B, I create a new entity B and a new knowledge that entity B lives in moist soils in cold and temperate regions. So I can infer that entity B is a plant. 
Combining the common sense knowledge and the new knowledge, I infer that the newanswer key of the new question should be A.
New Question: Which creature requires energy to move?
New Choices: A. entity A
B. entity B
New Knowledge: ["Entity A is eaten by weasel", "Entity B lives in moist soils in cold and temperate regions."]
New Answer Key: A
###
Original Question: [question_stem]
Choices: [formatted_choices]
Common Sense Knowledge: [commonsense_knowledge]
Answer Key: [original_answer_key]
Thought:"""


CONSTRUCT_CONFLICT_KNOW_PROMPT = """You are tasked with generating conflicting knowledge based on the given knowledge and creating a related multiple-choice question.
Follow these steps:

1. Generate Conflict Knowledge:
Create a conflicting statement or fact that contradicts the internal knowledge. This conflict should challenge the established understanding.
2. Formulate a Multiple Choice Question:
Create a question that asks for the truth regarding the conflicting knowledge. The question should be about the conflict knowledge. Provide two answer choices. Include:
A. One choice that aligns with the given knowledge.
B. One choice that supports the conflicting knowledge.

Your output should be as clean and clear as possible.
The Label of choice should be A. and B.
Do not output anything after the Desired Output.
Here is the knowledge you should refer:
###
[Taxon]
###
Desired Output Format:
Thought: <thought>
Conflicting Knowledge: <new_knowledge>
Question: <new_question_with_multiple_choice>
Let's think step by step.
###
"""