import sys
import os,csv
from tqdm import tqdm
import random

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '../..')))
# sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '.')))
from utils.utils import *

from llm.avior_api import *
from llm.gpt import *


relation_subject_dict = {
    "occupation": {"Person A", "Person B", "Person C"}, # subjects: humans
    "place of birth": {"Person A", "Person B", "Person C"}, # subjects: humans
    "genre": {"Entity A", "Entity B"}, # subjects: music, film
    "father": {"Person A", "Person B", "Person C"}, # subjects: humans
    "country": {"Entity A", "Entity B", "Entity C"}, # subjects: humans
    "producer": {"Film A", "Film B"}, # subjects: films
    "director": {"Film A", "Film B"}, # subjects: films
    "capital of": {"Place A", "Place B"}, # subjects: places
    "screenwriter": {"Movie A", "Film B"}, # subjects: films
    "composer": {"Work A", "Work B"}, # subjects: music
    "color": {"Entity A", "Entity B"}, # subjects: things
    "religion": {"Person A", "Person B", "Person C"}, # subjects: humans
    "sport": {"Entity A", "Entity B", "Entity C"}, # subjects: humans
    "author": {"Work A", "Work B"}, # subjects: books
    "mother": {"Person A", "Person B", "Person C"}, # subjects: humans
    "capital": {"Place A", "Place B"} # subjects: countries
}


relation_templates_adverbial = {
    "occupation": [
        "the person who frequently collaborates with [subj]",
        "the best friend of [subj]",
        "the famous friend of [subj]"
    ],
    "place of birth": [
        "the renowned figure who is a friend of [subj]",
        "the best friend of [subj]",
        "the person who frequently collaborates with [subj]"
    ],
    "genre": [
        "the influential entity previously related with [subj]"
    ],
    "father": [
        "the renowned figure with [subj]",
        "the famous person known by [subj]",
        "the best friend of [subj]"
    ],
    "country": [
        "the renowned entity similar to [subj]",
        "the notable figure similar to [subj]"
    ],
    "producer": [
        "the renowned product similar to [subj]",
        "the famous product similar to [subj]",
        "the prominent product like [subj]"
    ],
    "director": [
        "the renowned film similar to [subj]",
        "the famous film similar to [subj]",
        "the renowned movie similar to [subj]",
    ],
    "capital of": [
        "the famous place near [subj]",
        "the renowned place near [subj]",
        "the prominent place similar to [subj]"
    ],
    "screenwriter": [
        "the renowned screenplay similar to [subj]",
        "the famous TV shows similar to [subj]",
        "the prominent show like [subj]"
    ],
    "composer": [
        "the work similar to [subj]",
        "the prominent work similar to [subj]",
        "the influential work similar to [subj]"
    ],
    "color": [
        "the notable entity similar to [subj]",
        "the prominent entity similar to [subj]"
    ],
    "religion": [
        "the best friend of [subj]",
        "the prominent friend of [subj]",
    ],
    "sport": [
        "the prominent entity related to [subj]",
        "the famous entity similar to [subj]",
    ],
    "author": [
        "the prominent work similar to [subj]",
        "the influential work similar to [subj]"
    ],
    "mother": [
        "the renowned figure with [subj]",
        "the famous person known by [subj]",
        "the best friend of [subj]"
    ],
    "capital": [
        "the important place near [subj]",
        "the big place near [subj]",
        "the neighbor place of [subj]"
    ]
}


def filter_model_memories(input_file, output_file, model):
    data = read_jsonl_file(input_file)
    all_array = []
    print("length of data", len(data))
    totoal_price = 0
    price = 0

    for index, array in enumerate(tqdm(data)):
        prompt = "Verify the statement: " + array.get('memory_answer') + ".\n\nYour output can only be 'true' or 'false' or 'unknown'. Do not output anything other than these three words."
        if 'o1' in model:
            result, price = generate_o1_response(prompt, model)
        elif 'gpt' in input_file:
            result, price = generate_chatgpt_response(prompt, model)
        else:
            result = chat_completion(prompt, model)

        totoal_price += price
        print(result)
        print(array.get('memory_answer'))
        print("current price: ", totoal_price)
        if "true" in result.lower().strip(".").strip():
            all_array.append(array)

        if index % 20 == 0:
            print(len(all_array))
            write_json_file(all_array, output_file)

        if len(all_array) > 1992:
            break
    write_json_file(all_array, output_file)

    return all_array


# Define the function to process the input data
def add_new_entity_conflictQA(input_file, output_file):
    data = read_json_file(input_file)
    popqa = read_json_file("./data/popQA.json")
    question2entity = {i['question']:i['subj'] for i in popqa}
    question2prop = {i['question']:i['prop'] for i in popqa}

    for index, item in enumerate(tqdm(data)):
        # Extract relevant details
        question = item["question"]
        parametric_memory = item["parametric_memory"]
        counter_memory = item["counter_memory"]
        subj = question2entity[question]
        prop = question2prop[question]
        relation_type = prop
        mem_answer = item["memory_answer"]
        cnt_answer = item["counter_answer"]

        # Select a new subject
        new_subject = random.choice(list(relation_subject_dict[relation_type]))
        
        # Choose a template
        template = random.choice(relation_templates_adverbial[relation_type])
        
        # Replace [subj] in template with new_subject
        relation_sentence = template.replace("[subj]", new_subject)
        
        # Update question and counter_memory
        new_question = question.replace(subj, relation_sentence)
        
        new_counter_memory = counter_memory.replace(subj, new_subject)
        subj_split = subj.split()
        for token in subj_split:
            new_counter_memory = new_counter_memory.replace(token, new_subject)

        # new_counter_memory = f"{subj} is {relation_sentence}. {new_counter_memory}"
        new_counter_memory = f"{new_counter_memory}"
        
        prompt = "Make the answer shorter according to the Question Answer Pair. Do not change the answer! Just extract important words!\nQuestion: In what city was Erasmo Carlos born?\Answer: Erasmo Carlos was born in the city of Rio de Janeiro, Brazil. \nShort Answer: the city of Rio de Janeiro, Brazil\nQuestion: " + question + "\nKnowledge: " + mem_answer + "\nnShort Answer:"
        result = chat_completion(prompt, "LLAMA_3_70B")
        # result,price = generate_chatgpt_response(prompt, "gpt-4o-mini")
        mem_ans_short = result.split("Answer:")[-1].strip(".").strip()
        prompt = "Make the answer shorter according to the Question Answer Pair. Do not change the answer! Just extract important words!\nQuestion: In what city was Erasmo Carlos born?\Answer: Erasmo Carlos was born in the city of Rio de Janeiro, Brazil. \nnShort Answer: the city of Rio de Janeiro, Brazil\nQuestion: " + question + "\nKnowledge: " + cnt_answer + "\nnShort Answer:"
        result = chat_completion(prompt, "LLAMA_3_70B")
        # result,price = generate_chatgpt_response(prompt, "gpt-4o-mini")
        cnt_ans_short = result.split("Short Answer:")[-1].strip(".").strip()

        item['new_question'] = new_question
        item['new_memory'] = new_counter_memory
        item['new_old_relation'] = f"{subj} is {relation_sentence}."
        item['subj'] = subj
        item['property'] = prop
        item['memory_answer_short'] = mem_ans_short
        item['counter_answer_short'] = cnt_ans_short
        data[index] = item
        if index % 200==0:
            write_json_file(data, output_file)

    write_json_file(data, output_file)

model = "o1-preview"
filter_model_memories(f"./data/ConflictQA/conflictQA-popQA-gpt4.json", f"./data/ConflictQA/conflictQA-popQA-{model}.json", model)
add_new_entity_conflictQA(f"./data/ConflictQA/conflictQA-popQA-{model}.json", f"./data/ConflictQA/conflictQA-popQA-{model}_new_entity_separate_relation.json")