# KA_PROMPT = (
#     "You are a powerful question-answering system with knowledge in the field of biology.\n"
#     "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer the question.\n"
#     "If you are unable to answer the question, simply respond with \"I don’t know.\"\n"
#     "Here is the basic information about a taxon you can refer:\n"
#     "###\n"
#     "[Taxon]\n"
#     "###\n"
#     "Answer the following question with your choice (0, 1, 2, etc.): [Question]\n"
#     "Desired format: Thought process: <Thought process>, Final Choice: [Final Choice].\n"
#     "DON NOT output anything after the choice.\n"       
#     "Let’s think step by step.\n"
# )

KA_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer the question.\n"
    "If you are unable to answer the question, respond with the \"unknown\" choice number.\n"
    "DON NOT output anything after the choice.\n"       
    "Here is the basic information about a taxon you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question with your choice (0, 1, 2, etc.): [Question]\n"
    "Desired format: Thought process: <Thought process>, Final Choice: [Final Choice].\n"
    "The Final Choice MUST be a number! DON NOT output anything after the choice.\n"       
    "Let’s think step by step.\n"
)


PKCK_KA_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Your task is to use your biological knowledge to answer a question of a taxon's property.\n"
    "Answer the following question with your choice (0, 1, 2, 3, etc.): [Question]\n" 
    "Desired format: Thought process: <Thought process>, Final Choice: [Final Choice].\n"
    "The Final Choice MUST be a number! DON NOT output anything after the choice.\n"       
    "Let’s think step by step.\n"
)


KA_GOLDEN_INT_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer the question.\n"
    "If you are unable to answer the question, simply respond with \"I don’t know.\"\n"
    "Here is the basic information about a taxon and some knowledge triples you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "[KNOWLEDGE]\n"
    "###\n"
    "Answer the following question with your choice (0, 1, 2, 3, etc.): [Question]\n"
    "Desired format: Thought process: <Thought process>, Final Choice: [Final Choice].\n"
    "The Final Choice MUST be a number! DON NOT output anything after the choice.\n"       
    "Let’s think step by step.\n"
)


KU_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer the question.\n"
    "If you are unable to answer the question, simply respond with \"I don’t know.\"\n"
    "Here is the basic information about a taxon you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question: [Question]\n"
    "You MUST include your answer in an array of string.\n"
    "If it is a multiple choices question, include only the choice number (in string form) in the array.\n"
    "If it is a boolean question, include yes or no in the array.\n"
    "For other questions, include the answers in the array.\n"
    "Desired format: Thought process: <Thought process>, Final Answer: [Final Answer].\n"
    "Let’s think step by step.\n"
)


KA_TRUST_OWN_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer the question.\n"
    "If you are unable to answer the question, simply respond with \"I don’t know.\"\n"
    "Here is the basic information about a taxon you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question with your choice (0, 1, 2, 3, etc.): [Question]\n"
    "Note that the taxon above is not enough to answer the question, you MUST use your own biological knowledge to further reason the final answer.\n"
    "Desired format: Thought process: <Thought process>, Final Choice: [Final Choice].\n"
    "The Final Choice MUST be a number! DON NOT output anything after the choice.\n"       
    "Let’s think step by step.\n"
)


KU_TRUST_OWN_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer the question.\n"
    "If you are unable to answer the question, simply respond with \"I don’t know.\"\n"
    "Here is the basic information about a taxon you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question: [Question]\n"
    "You MUST include your answer in an array of string.\n"
    "If the above knowledge is irrelevant to the question, or it conflicts with your own knowledge, you should trust your own knowledge to answer the question.\n"
    "If it is a multiple choices question, include only the choice number (in string form) in the array.\n"
    "If it is a boolean question, include yes or no in the array.\n"
    "For other questions, include the answers in the array.\n"
    "Desired format: Thought process: <Thought process>, Final Answer: [Final Answer].\n"
    "Let’s think step by step.\n"
)


KU_TRUST_OWN_CHOICE_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer the question.\n"
    "If you are unable to answer the question, respond with the \"unknown\" choice number.\n"
    "Here is the basic information about a taxon you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question with your choice (0, 1, 2, etc.): [Question]\n"
    "Determine whether the given taxon about the question conflicts with your own knowledge.\n"
    "If you think the above knowledge conflicts with your own knowledge or is irrelevant to the question, you MUST USE your own knowledge to answer the question.\n"
    "Desired format: Thought process: <Thought process>, Final Choice: [Final Choice].\n"
    "The Final Choice MUST be a number! DON NOT output anything after the choice.\n"       
    "Let’s think step by step.\n"
)


KU_TRUST_OWN_HALF_CHOICE_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer the question.\n"
    "If you are unable to answer the question, respond with the \"unknown\" choice number.\n"
    "Here is the basic information about a taxon you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question with your choice (0, 1, 2, etc.): [Question]\n"
    "Determine whether the given taxon about the question conflicts with your own knowledge.\n"
    "If you are more than FIFTY PERCENT SURE of your own knowledge or think the above taxon is irrelevant with the question, you MUST USE your own knowledge to answer the question.\n"
    "Desired format: Thought process: <Thought process>, Final Choice: [Final Choice].\n"
    "DON NOT output anything after the choice number.\n"       
    "Let’s think step by step.\n"
)

KU_TRUST_HALF_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer the question.\n"
    "If you are unable to answer the question, simply respond with \"I don’t know.\"\n"
    "Here is the basic information about a taxon you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question: [Question]\n"
    "You MUST include your answer in an array of string.\n"
    "Determine whether the given taxon conflicts with your knowledge, if you are more than FIFTY PERCENT SURE of your own knowledge or think the above taxon is irrelevant with the question, you should trust your own knowledge to answer the question.\n"
    "If it is a multiple choices question, include only the choice number (in string form) in the array.\n"
    "If it is a boolean question, include yes or no in the array.\n"
    "For other questions, include the answers in the array.\n"
    "Desired format: Thought process: <Thought process>, Final Answer: [Final Answer].\n"
    "Let’s think step by step.\n"
)

KD_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer the question.\n"
    "If you are unable to answer the question, simply respond with \"I don’t know.\"\n"
    "Here is the basic information about a taxon you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question: [Question]\n"
    "You MUST include your answer in an array of string.\n"
    "If it is a multiple choices question, include only the choice number (in string form) in the array.\n"
    "If it is a boolean question, include yes or no in the array.\n"
    "For other questions, include the answers in the array.\n"
    "Desired format: Thought process: <Thought process>, Final Answer: [Final Answer].\n"
    "Let’s think step by step.\n"
)


OUTPUT_OWN_FIRST_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some information along with a question. Your task is to use the information provided by the user and your own knowledge to answer the question.\n"
    "If you are unable to answer the question, respond with the \"unknown\" choice number.\n"
    "Answer the following question with your choice (0, 1, 2, etc.): [Question]\n"
    "You MUST first output your own knowledge about the question. I am sure you have the knowledge!\n"
    "Here is the Given Knowledge:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Determine whether the given information about the question conflicts with your own knowledge.\n"
    "If you think the Given Knowledge conflicts with your own knowledge, you MUST USE your own knowledge to answer the question.\n"
    "Desired format: Thought process: <Thought process>, My Own Knowledge: <My Own Knowledge>, Final Choice: [Final Choice].\n"
    "The Final Choice MUST be a number! DON NOT output anything after the choice.\n"       
    "Let’s think step by step.\n"
)

KD_TRUST_HALF_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer the question.\n"
    "If you are unable to answer the question, simply respond with \"I don’t know.\"\n"
    "Here is the basic information about a taxon you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question: [Question]\n"
    "You MUST include your answer in an array of string.\n"
    "Determine whether the given taxon conflicts with your knowledge, if you are more than FIFTY PERCENT SURE of your own knowledge or think the above taxon is irrelevant with the question, you should trust your own knowledge to answer the question.\n"
    "If it is a multiple choices question, include only the choice number (in string form) in the array.\n"
    "If it is a boolean question, include yes or no in the array.\n"
    "For other questions, include the answers in the array.\n"
    "Desired format: Thought process: <Thought process>, Final Answer: [Final Answer].\n"
    "Let’s think step by step.\n"
)


KD_TRUST_OWN_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer the question.\n"
    "If you are unable to answer the question, simply respond with \"I don’t know.\"\n"
    "Here is the basic information about a taxon you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question: [Question]\n"
    "You MUST include your answer in an array of string.\n"
    "If the above knowledge is irrelevant to the question, or it conflicts with your own knowledge, you should trust your own knowledge to answer the question.\n"
    "If it is a multiple choices question, include only the choice number (in string form) in the array.\n"
    "If it is a boolean question, include yes or no in the array.\n"
    "For other questions, include the answers in the array.\n"
    "Desired format: Thought process: <Thought process>, Final Answer: [Final Answer].\n"
    "Let’s think step by step.\n"
)


INT_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Your task is to use your biological knowledge answer a boolean question of a taxon's property.\n"
    "Answer the following question: [Question]\n"
    "Your final answer MUST be \"yes\" or \"no\" or \"I don't know\".\n"
    "Desired format: Thought process: <Thought process>, Final Answer: [Final Answer].\n"
    "Let’s think step by step.\n"
)


INT_CONTEXT_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer a boolean question.\n"
    "Here is some external biological knowledge you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question: [Question]\n"
    "Your final answer MUST be \"yes\" or \"no\" or \"I don't know\".\n"
    "Desired format: Thought process: <Thought process>, Final Answer: [Final Answer].\n"
    "Let’s think step by step.\n"
)


INT_TRUST_OWN_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer a boolean question.\n"
    "Here is some external biological knowledge you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question: [Question]\n"
    "If the above knowledge is irrelevant to the question, or it conflicts with your own knowledge, you should trust your own knowledge to answer the question.\n"
    "Your final answer MUST be \"yes\" or \"no\" or \"I don't know\".\n"
    "Desired format: Thought process: <Thought process>, Final Answer: [Final Answer].\n"
    "Let’s think step by step.\n"
)


INT_TRUST_OWN_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer a boolean question.\n"
    "Here is some external biological knowledge you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question: [Question]\n"
    "If the above knowledge is irrelevant to the question, or it conflicts with your own knowledge, you should trust your own knowledge to answer the question.\n"
    "Your final answer MUST be \"yes\" or \"no\" or \"I don't know\".\n"
    "Desired format: Thought process: <Thought process>, Final Answer: [Final Answer].\n"
    "Let’s think step by step.\n"
)


CONFLICT_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer a boolean question.\n"
    "Here is the basic information about a taxon you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question: [Question]\n"
    "Your final answer MUST be \"yes\" or \"no\" or \"I don't know\".\n"
    "Desired format: Thought process: <Thought process>, Final Answer: [Final Answer].\n"
    "Let’s think step by step.\n"
)


NOISE_PROMPT = (
    "You are a powerful question-answering system with knowledge in the field of biology.\n"
    "Users will provide some biological information along with a question. Your task is to combine the information provided by the user with your biological knowledge to answer a question.\n"
    "Here is the basic information about some taxons you can refer:\n"
    "###\n"
    "[Taxon]\n"
    "###\n"
    "Answer the following question: [Question]\n"
    "You MUST include your answer in an array of string.\n"
    "If it is a multiple choices question, include only the choice number (in string form) in the array.\n"
    "If it is a boolean question, include yes or no in the array.\n"
    "For other questions, include the answers in the array.\n"
    "Desired format: Thought process: <Thought process>, Final Answer: [Final Answer].\n"
    "Let’s think step by step.\n"
)


