import sys
import os

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '../../')))
from utils.utils import *
from llm.avior_api import *
from llm.gpt import *
from prompt.Musique_prompt import *
import numpy as np
from tqdm import tqdm


instruction_template_dict = {
    "Direct": DIRECT_REASONING_PROMPT,
    "NP": REASONING_NEUTRAL_PROMPT,
    "TOKP": CON_TRUST_OWN_KNOWLEDGE_PROMPT,
    "TOHP": CON_TRUST_OWN_HALF_PROMPT,
    "OKF": CON_OUTPUT_OWN_FIRST_PROMPT,
}

def generate_prompt(taxon_info, question, question_type, know_triple_list=None):
    """
    Generate a prompt based on the given taxon information and question.
    
    Args:
    taxon_info (str): The taxon information to be inserted into the prompt.
    question (str): The question to be inserted into the prompt.
    
    Returns:
    str: The formatted prompt.
    """
    
    instruction_template = instruction_template_dict[question_type]
 
    taxon_info_str = json.dumps(taxon_info, indent=2) if isinstance(taxon_info, dict) or  isinstance(taxon_info, list) else str(taxon_info)
    question_str = question if isinstance(question, str) else str(question)
    if know_triple_list:
        know_triple_list_str = json.dumps(know_triple_list, indent=2) if isinstance(know_triple_list, dict) or  isinstance(know_triple_list, list) else str(know_triple_list)

    if question_type == "Direct":
        prompt = instruction_template.replace("[Question]", question_str)
    else:
        prompt = instruction_template.replace("[Taxon]", taxon_info_str).replace("[Question]", question_str)

    if "[KNOWLEDGE]" in prompt:
        prompt = prompt.replace("[KNOWLEDGE]", know_triple_list_str)

    return prompt


def build_paragraph_dict_pool(model):
    origin_data = read_json_file(f"./data/Musique/musique_ans_v1.0_dev.jsonl")
    all_knowledge = {}
    all_answer = {}
    for item in origin_data:
        question = item.get("question")
        paragraphs = item.get("paragraphs")
        invalid_paragraph = []
        invalid_answer = []
        for paragraph in paragraphs:
            if paragraph['is_supporting']==False:
                invalid_paragraph.append(paragraph['paragraph_text'])
                invalid_answer.append(paragraph['title'])
        all_knowledge[question] = invalid_paragraph
        all_answer[question] = invalid_answer
    return all_knowledge, all_answer


def whole_evaluation(input_file, output_file, model):
    """
    Process the JSON file to generate prompts and write them to an output file.
    
    Args:
    input_file (str): The path to the input JSON file containing questions and taxon information.
    output_file (str): The path to the output file where prompts will be saved.
    """
    data = read_json_file(input_file)
    question2para_dict, question2answer_dict = build_paragraph_dict_pool(model)
    trust_pk_np_list = []
    trust_ck_np_list = []
    unknown_np_list = []

    trust_pk_tokp_list = []
    trust_ck_tokp_list = []
    unknown_tokp_list = []
   
    trust_pk_okf_list = []
    trust_ck_okf_list = []
    unknown_okf_list = []
    new_data = []
    total_price = 0
    price = 0

    for index, item in enumerate(tqdm(data)):
        question = item.get('new_question')

        trust_pk_np = 0
        trust_ck_np = 0
        unknown_np = 0

        trust_pk_tokp = 0
        trust_ck_tokp = 0
        unknown_tokp = 0


        trust_pk_okf = 0
        trust_ck_okf = 0
        unknown_okf = 0

        random_option = get_random_items(question2para_dict[item['question']])
        new_question = question + "2. Unknown"

        item['noise_question'] = new_question
        item['random_option'] = random_option
        # neutral prompt, ck in context
        prompt = generate_prompt("\n###\n".join(random_option) , new_question, "NP")
        if 'o1' in model:
            result, price = generate_o1_response(prompt, model)
        elif "gpt" in model:
            result, price = generate_chatgpt_response(prompt, model)
        else:
            result = chat_completion(prompt, model)

        print(prompt)
        print(result)
        total_price += price
        print("current total price: ", total_price)
        item['np_result'] = result

        result = result.split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]
        if "0" in result:
            trust_pk_np = True
        elif "2" in result:
            unknown_np = True
        else:
            trust_ck_np = True

        trust_pk_np_list.append(trust_pk_np)
        trust_ck_np_list.append(trust_ck_np)
        unknown_np_list.append(unknown_np)

        item['trust_pk_np'] = trust_pk_np
        item['trust_ck_np'] = trust_ck_np
        item['unknown_np'] = unknown_np

        print("current neutral prompt trust pk acc: ", np.mean(trust_pk_np_list))
        print("current neutral prompt trust ck acc: ", np.mean(trust_ck_np_list))
        print("current neutral prompt unknown: ", np.mean(unknown_np_list))

        # trust own prompt, ck in context, ask to use own knowledge
        prompt = generate_prompt("\n###\n".join(random_option) , new_question, "TOKP")
        if 'o1' in model:
            result, price = generate_o1_response(prompt, model)
        elif "gpt" in model:
            result, price = generate_chatgpt_response(prompt, model)
        else:
            result = chat_completion(prompt, model)

        print(prompt)
        print(result)
        total_price += price
        print("current total price: ", total_price)
        item['tokp_result'] = result

        result = result.split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]
        if "0" in result:
            trust_pk_tokp = True
        elif "2" in result:
            unknown_tokp = True
        else:
            trust_ck_tokp = True
        
        trust_pk_tokp_list.append(trust_pk_tokp)
        trust_ck_tokp_list.append(trust_ck_tokp)
        unknown_tokp_list.append(unknown_tokp)

        item['trust_pk_tokp'] = trust_pk_tokp
        item['trust_ck_tokp'] = trust_ck_tokp
        item['unknown_tokp'] = unknown_tokp

        print("current trust own prompt trust pk acc: ", np.mean(trust_pk_tokp_list))
        print("current trust own prompt trust ck acc: ", np.mean(trust_ck_tokp_list))
        print("current trust own prompt unknown: ", np.mean(unknown_tokp_list))

        # own knowledge first, ck in context, ask to use own knowledge
        prompt = generate_prompt("\n###\n".join(random_option) , new_question, "OKF")

        if 'o1' in model:
            result, price = generate_o1_response(prompt, model)
        elif "gpt" in model:
            result, price = generate_chatgpt_response(prompt, model)
        else:
            result = chat_completion(prompt, model)

        print(prompt)
        print(result)
        total_price += price
        print("current total price: ", total_price)
        item['okf_result'] = result

        result = result.split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]

        if "0" in result:
            trust_pk_okf = True
        elif "2" in result:
            unknown_okf = True
        else:
            trust_ck_okf = True

        trust_pk_okf_list.append(trust_pk_okf)
        trust_ck_okf_list.append(trust_ck_okf)
        unknown_okf_list.append(unknown_okf)

        item['trust_pk_okf'] = trust_pk_okf
        item['trust_ck_okf'] = trust_ck_okf
        item['unknown_okf'] = unknown_okf

        print("current own knowledge first trust pk acc: ", np.mean(trust_pk_okf_list))
        print("current own knowledge first trust ck acc: ", np.mean(trust_ck_okf_list))
        print("current own knowledge first unknown: ", np.mean(unknown_okf_list))

        new_data.append(item)
        if index % 20 == 0:
            write_json_file(new_data, output_file)

    write_json_file(new_data, output_file)


def whole_metrics(input_file, output_file, model):
    """
    Process the JSON file to generate prompts and write them to an output file.
    
    Args:
    input_file (str): The path to the input JSON file containing questions and taxon information.
    output_file (str): The path to the output file where prompts will be saved.
    """
    data = read_json_file(output_file)
    question2para_dict, question2answer_dict = build_paragraph_dict_pool(model)
    trust_pk_np_list = []
    trust_ck_np_list = []
    unknown_np_list = []

    trust_pk_tokp_list = []
    trust_ck_tokp_list = []
    unknown_tokp_list = []
   
    trust_pk_okf_list = []
    trust_ck_okf_list = []
    unknown_okf_list = []
    new_data = []

    for index, item in enumerate(tqdm(data)):
        question = item.get('new_question')

        trust_pk_np = 0
        trust_ck_np = 0
        unknown_np = 0

        trust_pk_tokp = 0
        trust_ck_tokp = 0
        unknown_tokp = 0

        trust_pk_okf = 0
        trust_ck_okf = 0
        unknown_okf = 0

        random_option = get_random_items(question2para_dict[item['question']])
        new_question = question + "2. Unknown"

        item['noise_question'] = new_question
        item['random_option'] = random_option

        # neutral prompt, ck in context
        result = item['np_result'].split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]

        if "0" in result:
            trust_pk_np = True
        elif "2" in result:
            unknown_np = True
        else:
            trust_ck_np = True

        trust_pk_np_list.append(trust_pk_np)
        trust_ck_np_list.append(trust_ck_np)
        unknown_np_list.append(unknown_np)

        print("current neutral prompt trust pk acc: ", np.mean(trust_pk_np_list))
        print("current neutral prompt trust ck acc: ", np.mean(trust_ck_np_list))
        print("current neutral prompt unknown: ", np.mean(unknown_np_list))

        # trust own prompt, ck in context, ask to use own knowledge
        result = item['tokp_result'].split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]

        if "0" in result:
            trust_pk_tokp = True
        elif "2" in result:
            unknown_tokp = True
        else:
            trust_ck_tokp = True
        
        trust_pk_tokp_list.append(trust_pk_tokp)
        trust_ck_tokp_list.append(trust_ck_tokp)
        unknown_tokp_list.append(unknown_tokp)

        print("current trust own prompt trust pk acc: ", np.mean(trust_pk_tokp_list))
        print("current trust own prompt trust ck acc: ", np.mean(trust_ck_tokp_list))
        print("current trust own prompt unknown: ", np.mean(unknown_tokp_list))

        # own knowledge first, ck in context, ask to use own knowledge
        
        result = item['okf_result'].split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]

        if "0" in result:
            trust_pk_okf = True
        elif "2" in result:
            unknown_okf = True
        else:
            trust_ck_okf = True

        trust_pk_okf_list.append(trust_pk_okf)
        trust_ck_okf_list.append(trust_ck_okf)
        unknown_okf_list.append(unknown_okf)


        print("current own knowledge first trust pk acc: ", np.mean(trust_pk_okf_list))
        print("current own knowledge first trust ck acc: ", np.mean(trust_ck_okf_list))
        print("current own knowledge first unknown: ", np.mean(unknown_okf_list))
        print("length of data: ", len(unknown_okf_list))




def okf_evaluation(input_file, output_file, model):
    """
    Process the JSON file to generate prompts and write them to an output file.
    
    Args:
    input_file (str): The path to the input JSON file containing questions and taxon information.
    output_file (str): The path to the output file where prompts will be saved.
    """
    data = read_json_file(input_file)
    question2para_dict, question2answer_dict = build_paragraph_dict_pool(model)
    trust_pk_np_list = []
    trust_ck_np_list = []
    unknown_np_list = []

    trust_pk_tokp_list = []
    trust_ck_tokp_list = []
    unknown_tokp_list = []

    trust_pk_okf_list = []
    trust_ck_okf_list = []
    unknown_okf_list = []
    
    new_data = []
    total_price = 0
    price = 0

    for index, item in enumerate(tqdm(data)):
        # if "trust_pk_np" not in item.keys():
        #     continue
        
        # if "trust_ck_okf" in item.keys():
        #     continue
        question = item.get('new_question')
        trust_pk_okf = 0
        trust_ck_okf = 0
        unknown_okf = 0

        random_option = get_random_items(question2para_dict[item['question']])
        new_question = question + "2. Unknown"

        item['noise_question'] = new_question
        item['random_option'] = random_option
        # neutral prompt, ck in context
        trust_pk_np_list.append(item['trust_pk_np'])
        trust_ck_np_list.append(item['trust_ck_np'])
        unknown_np_list.append(item['unkown_np'])

        print("current neutral prompt trust pk acc: ", np.mean(trust_pk_np_list))
        print("current neutral prompt trust ck acc: ", np.mean(trust_ck_np_list))
        print("current neutral prompt unknown: ", np.mean(unknown_np_list))

        # trust own prompt, ck in context, ask to use own knowledge
        trust_pk_tokp_list.append(item['trust_pk_tokp'])
        trust_ck_tokp_list.append(item['trust_ck_tokp'])
        unknown_tokp_list.append(item['unkown_tokp'])

        print("current trust own prompt trust pk acc: ", np.mean(trust_pk_tokp_list))
        print("current trust own prompt trust ck acc: ", np.mean(trust_ck_tokp_list))
        print("current trust own prompt unknown: ", np.mean(unknown_tokp_list))

        # own knowledge first, ck in context, ask to use own knowledge
        prompt = generate_prompt("\n###\n".join(random_option) , new_question, "OKF")

        if 'o1' in model:
            result, price = generate_o1_response(prompt, model)
        elif "gpt" in model:
            result, price = generate_chatgpt_response(prompt, model)
        else:
            result = chat_completion(prompt, model)

        print(prompt)
        print(result)
        total_price += price
        print("current total price: ", total_price)

        item['okf_result'] = result

        result = result.split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()

        if result == "0":
            trust_pk_okf = 1
        elif result == "2":
            unknown_okf = 1
        else:
            trust_ck_okf = 1

        trust_pk_okf_list.append(trust_pk_okf)
        trust_ck_okf_list.append(trust_ck_okf)
        unknown_okf_list.append(unknown_okf)

        item['trust_pk_okf'] = trust_pk_okf
        item['trust_ck_okf'] = trust_ck_okf
        item['unkown_okf'] = unknown_okf

        print("current own knowledge first trust pk acc: ", np.mean(trust_pk_okf_list))
        print("current own knowledge first trust ck acc: ", np.mean(trust_ck_okf_list))
        print("current own knowledge first unknown: ", np.mean(unknown_okf_list))

        new_data.append(item)
        if index % 300 == 0:
            write_json_file(new_data, output_file)

    write_json_file(new_data, output_file)



# Example usage
model = "o1-preview" # "gpt-4o-mini" or "LLAMA_3_70B"


input_file = f'./data/Musique/musique_dev_verified_{model}_conflict.json'
output_file = f'./output/musique/dev_{model}_noise.json'
output_file_okf = f'./output/musique/dev_{model}_noise_okf.json'

whole_evaluation(input_file, output_file_okf, model)