import sys
import os

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '../..')))
from utils.utils import *
from llm.avior_api import *
from llm.gpt import *
from prompt.OpenbookQA_prompt import *
import numpy as np
from tqdm import tqdm


instruction_template_dict = {
    "Direct": DIRECT_REASONING_PROMPT,
    "Neutral": REASONING_NEUTRAL_PROMPT,
    "TOKP": REASONING_TRUST_OWN_KNOWLEDGE_PROMPT,
}

def generate_prompt(taxon_info, question, question_type, know_triple_list=None):
    """
    Generate a prompt based on the given taxon information and question.
    
    Args:
    taxon_info (str): The taxon information to be inserted into the prompt.
    question (str): The question to be inserted into the prompt.
    
    Returns:
    str: The formatted prompt.
    """
    
    instruction_template = instruction_template_dict[question_type]
 
    taxon_info_str = json.dumps(taxon_info, indent=2) if isinstance(taxon_info, dict) or  isinstance(taxon_info, list) else str(taxon_info)
    question_str = question if isinstance(question, str) else str(question)
    if know_triple_list:
        know_triple_list_str = json.dumps(know_triple_list, indent=2) if isinstance(know_triple_list, dict) or  isinstance(know_triple_list, list) else str(know_triple_list)

    if question_type == "Direct":
        prompt = instruction_template.replace("[Question]", question_str)
    else:
        prompt = instruction_template.replace("[Taxon]", taxon_info_str).replace("[Question]", question_str)

    if "[KNOWLEDGE]" in prompt:
        prompt = prompt.replace("[KNOWLEDGE]", know_triple_list_str)

    return prompt

def golden_evaluation(input_file, output_file, model):
    """
    Process the JSON file to generate prompts and write them to an output file.
    
    Args:
    input_file (str): The path to the input JSON file containing questions and taxon information.
    output_file (str): The path to the output file where prompts will be saved.
    """
    data = read_json_file(input_file)

    trust_pk_direct_list = []
    trust_ck_direct_list = []
    unkown_direct_list = []
    total_price = 0
    price = 0
    

    for index, item in enumerate(tqdm(data)):
        if "unknown_golden" in item.keys():
            continue

        question = item.get('new_question')
        choices = item.get('new_choices')
        new_knowledge = item.get('new_knowledge')
        internal_knowledge = item.get('internal_knowledge')
        answer = item.get('answer')

        trust_pk_direct = 0
        trust_ck_direct = 0
        unknown_direct = 0

        new_question = question + "\n" + choices + "\n"+str(chr(ord('A') + len(choices.split("\n"))))+". Unknown"
        flat_new_knowledge = [sublist if type(sublist)==str else str(sublist) for sublist in new_knowledge ]
        all_knowledge = flat_new_knowledge + internal_knowledge

        prompt = generate_prompt("\n###\n".join(all_knowledge), new_question, "Neutral")

        if 'o1' in model:
            result, price = generate_o1_response(prompt, model)
        elif "gpt" in model:
            result, price = generate_chatgpt_response(prompt, model)
        else:
            result = chat_completion(prompt, model)

        print(prompt)
        print(result)
        print(answer)
        total_price += price
        print("current total price: ", total_price)

        item['golden_result'] = result
        result = result.split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]
        trust_pk_direct = (answer.lower() in result)
        # trust_ck_direct = (result == "1")
        unknown_direct = (result == str(chr(ord('A') + len(choices.split("\n")))).lower())

        trust_pk_direct_list.append(trust_pk_direct)
        # trust_ck_direct_list.append(trust_ck_direct)
        unkown_direct_list.append(unknown_direct)
        item['trust_pk_golden'] = trust_pk_direct
        # item['trust_ck_golden'] = trust_ck_direct
        item['unknown_golden'] = unknown_direct

        print("current golden trust pk acc: ", np.mean(trust_pk_direct_list))
        # print("current golden trust ck acc: ", np.mean(trust_ck_direct_list))
        print("current golden unknown: ", np.mean(unkown_direct_list))

        data[index]=item

        if index % 20 == 0:
            write_json_file(data, output_file)

    write_json_file(data, output_file)



def whole_evaluation(input_file, output_file, model):
    """
    Process the JSON file to generate prompts and write them to an output file.
    
    Args:
    input_file (str): The path to the input JSON file containing questions and taxon information.
    output_file (str): The path to the output file where prompts will be saved.
    """
    data = read_json_file(input_file)

    trust_pk_direct_list = []
    trust_ck_direct_list = []
    unkown_direct_list = []

    trust_pk_np_list = []
    trust_ck_np_list = []
    unkown_np_list = []

    trust_pk_tokp_list = []
    trust_ck_tokp_list = []
    unkown_tokp_list = []
    total_price = 0
    price = 0

    for index, item in enumerate(tqdm(data)):
        question = item.get('new_question')
        choices = item.get('new_choices')
        new_knowledge = item.get('new_knowledge')
        answer = item.get('answer')

        trust_pk_direct = 0
        trust_ck_direct = 0
        unknown_direct = 0

        trust_pk_np = 0
        trust_ck_np = 0
        unknown_np = 0

        trust_pk_tokp = 0
        trust_ck_tokp = 0
        unknown_tokp = 0


        new_question = question + "\n" + choices + "\n" + str(chr(ord('A') + len(choices.split("\n")))) + ". Unknown"
        # direct answer
        prompt = generate_prompt("", new_question, "Direct")
        if 'o1' in model:
            result, price = generate_o1_response(prompt, model)
        elif "gpt" in model:
            result, price = generate_chatgpt_response(prompt, model)
        else:
            result = chat_completion(prompt, model)

        print(prompt)
        print(result)
        print(answer)
        total_price += price
        print("current total price: ", total_price)


        item['direct_result'] = result
        result = result.split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]

        trust_pk_direct = (answer.lower() in result)
        # trust_ck_direct = (result == "1")
        unknown_direct = (str(chr(ord('A') + len(choices.split("\n")))).lower() in result)

        trust_pk_direct_list.append(trust_pk_direct)
        # trust_ck_direct_list.append(trust_ck_direct)
        unkown_direct_list.append(unknown_direct)
        item['trust_pk_direct'] = trust_pk_direct
        # item['trust_ck_direct'] = trust_ck_direct
        item['unknown_direct'] = unknown_direct

        print("current direct trust pk acc: ", np.mean(trust_pk_direct_list))
        # print("current direct trust ck acc: ", np.mean(trust_ck_direct_list))
        print("current direct unknown: ", np.mean(unkown_direct_list))

        if type(new_knowledge[0]) == list:
            new_knowledge = new_knowledge[0]

        # neutral prompt, ck in context
        prompt = generate_prompt("\n###\n".join(new_knowledge), new_question, "Neutral")
        if 'o1' in model:
            result, price = generate_o1_response(prompt, model)
        elif "gpt" in model:
            result, price = generate_chatgpt_response(prompt, model)
        else:
            result = chat_completion(prompt, model)

        print(prompt)
        print(result)
        print(answer)
        total_price += price
        print("current total price: ", total_price)

        item['np_result'] = result

        result = result.split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]

        trust_pk_np = (answer.lower() in result)
        # trust_ck_np = (result == "1")
        unknown_np = (str(chr(ord('A') + len(choices.split("\n")))).lower() in result)

        trust_pk_np_list.append(trust_pk_np)
        # trust_ck_np_list.append(trust_ck_np)
        unkown_np_list.append(unknown_np)

        item['trust_pk_np'] = trust_pk_np
        # item['trust_ck_np'] = trust_ck_np
        item['unknown_np'] = unknown_np

        print("current neutral prompt trust pk acc: ", np.mean(trust_pk_np_list))
        # print("current neutral prompt trust ck acc: ", np.mean(trust_ck_np_list))
        print("current neutral prompt unknown: ", np.mean(unkown_np_list))

        # trust own prompt, ck in context, ask to use own knowledge
        prompt = generate_prompt("\n###\n".join(new_knowledge), new_question, "TOKP")
        if 'o1' in model:
            result, price = generate_o1_response(prompt, model)
        elif "gpt" in model:
            result, price = generate_chatgpt_response(prompt, model)
        else:
            result = chat_completion(prompt, model)

        print(prompt)
        print(result)
        print(answer)
        total_price += price
        print("current total price: ", total_price)

        item['tokp_result'] = result

        result = result.split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]

        trust_pk_tokp = (answer.lower() in result)
        # trust_ck_tokp = (result == "1")
        unknown_tokp = (str(chr(ord('A') + len(choices.split("\n")))).lower() in result)
        
        trust_pk_tokp_list.append(trust_pk_tokp)
        # trust_ck_tokp_list.append(trust_ck_tokp)
        unkown_tokp_list.append(unknown_tokp)

        item['trust_pk_tokp'] = trust_pk_tokp
        # item['trust_ck_tokp'] = trust_ck_tokp
        item['unknown_tokp'] = unknown_tokp

        print("current trust own prompt trust pk acc: ", np.mean(trust_pk_tokp_list))
        # print("current trust own prompt trust ck acc: ", np.mean(trust_ck_tokp_list))
        print("current trust own prompt unknown: ", np.mean(unkown_tokp_list))

        data[index]=item

        if index % 30 == 0:
            write_json_file(data, output_file)

    write_json_file(data, output_file)



def whole_metrics(input_file, output_file, model):
    """
    Process the JSON file to generate prompts and write them to an output file.
    
    Args:
    input_file (str): The path to the input JSON file containing questions and taxon information.
    output_file (str): The path to the output file where prompts will be saved.
    """
    data = read_json_file(output_file)

    trust_pk_direct_list = []
    trust_ck_direct_list = []
    unkown_direct_list = []

    trust_pk_np_list = []
    trust_ck_np_list = []
    unkown_np_list = []

    trust_pk_tokp_list = []
    trust_ck_tokp_list = []
    unkown_tokp_list = []

    for index, item in enumerate(tqdm(data)):
        question = item.get('new_question')
        choices = item.get('new_choices')
        new_knowledge = item.get('new_knowledge')
        answer = item.get('answer')

        trust_pk_direct = 0
        trust_ck_direct = 0
        unknown_direct = 0

        trust_pk_np = 0
        trust_ck_np = 0
        unknown_np = 0

        trust_pk_tokp = 0
        trust_ck_tokp = 0
        unknown_tokp = 0


        new_question = question + "\n" + choices + "\n" + str(chr(ord('A') + len(choices.split("\n")))) + ". Unknown"
        # direct answer
        result = item['direct_result'].split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]

        trust_pk_direct = (answer.lower() in result)
        # trust_ck_direct = (result == "1")
        unknown_direct = (str(chr(ord('A') + len(choices.split("\n")))).lower() in result)

        trust_pk_direct_list.append(trust_pk_direct)
        # trust_ck_direct_list.append(trust_ck_direct)
        unkown_direct_list.append(unknown_direct)

        print("current direct trust pk acc: ", np.mean(trust_pk_direct_list))
        # print("current direct trust ck acc: ", np.mean(trust_ck_direct_list))
        print("current direct unknown: ", np.mean(unkown_direct_list))

        if type(new_knowledge[0]) == list:
            new_knowledge = new_knowledge[0]

        # neutral prompt, ck in context
        result = item['np_result'].split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]

        trust_pk_np = (answer.lower() in result)
        # trust_ck_np = (result == "1")
        unknown_np = (str(chr(ord('A') + len(choices.split("\n")))).lower() in result)

        trust_pk_np_list.append(trust_pk_np)
        # trust_ck_np_list.append(trust_ck_np)
        unkown_np_list.append(unknown_np)

        print("current neutral prompt trust pk acc: ", np.mean(trust_pk_np_list))
        # print("current neutral prompt trust ck acc: ", np.mean(trust_ck_np_list))
        print("current neutral prompt unknown: ", np.mean(unkown_np_list))

        # trust own prompt, ck in context, ask to use own knowledge
        result = item['tokp_result'].split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]

        trust_pk_tokp = (answer.lower() in result)
        # trust_ck_tokp = (result == "1")
        unknown_tokp = (str(chr(ord('A') + len(choices.split("\n")))).lower() in result)
        
        trust_pk_tokp_list.append(trust_pk_tokp)
        # trust_ck_tokp_list.append(trust_ck_tokp)
        unkown_tokp_list.append(unknown_tokp)

        print("current trust own prompt trust pk acc: ", np.mean(trust_pk_tokp_list))
        # print("current trust own prompt trust ck acc: ", np.mean(trust_ck_tokp_list))
        print("current trust own prompt unknown: ", np.mean(unkown_tokp_list))

        print("length of data: ", len(unkown_tokp_list))

def result_evaluation(input_file, output_file, model):
    """
    Process the JSON file to generate prompts and write them to an output file.
    
    Args:
    input_file (str): The path to the input JSON file containing questions and taxon information.
    output_file (str): The path to the output file where prompts will be saved.
    """
    data = read_json_file(input_file)

    trust_pk_direct_list = []
    trust_ck_direct_list = []
    unkown_direct_list = []

    trust_pk_np_list = []
    trust_ck_np_list = []
    unkown_np_list = []

    trust_pk_tokp_list = []
    trust_ck_tokp_list = []
    unkown_tokp_list = []

    for index, item in enumerate(tqdm(data)):
        question = item.get('new_question')
        choices = item.get('new_choices')
        new_knowledge = item.get('new_knowledge')
        answer = item.get('answer')

        trust_pk_direct = 0
        trust_ck_direct = 0
        unknown_direct = 0

        trust_pk_np = 0
        trust_ck_np = 0
        unknown_np = 0

        trust_pk_tokp = 0
        trust_ck_tokp = 0
        unknown_tokp = 0


        new_question = question + "\n" + choices + "\n" + str(chr(ord('A') + len(choices.split("\n")))) + ". Unknown"
        # direct answer
        result = item['direct_result']
        result = result.split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]

        trust_pk_direct = (answer.lower() in result)
        # trust_ck_direct = (result == "1")
        unknown_direct = (str(chr(ord('A') + len(choices.split("\n")))).lower() in result)

        trust_pk_direct_list.append(trust_pk_direct)
        # trust_ck_direct_list.append(trust_ck_direct)
        unkown_direct_list.append(unknown_direct)


        print("current direct trust pk acc: ", np.mean(trust_pk_direct_list))
        # print("current direct trust ck acc: ", np.mean(trust_ck_direct_list))
        print("current direct unknown: ", np.mean(unkown_direct_list))

        if type(new_knowledge[0]) == list:
            new_knowledge = new_knowledge[0]

        # neutral prompt, ck in context
        result = item['np_result'].split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]

        trust_pk_np = (answer.lower() in result)
        # trust_ck_np = (result == "1")
        unknown_np = (str(chr(ord('A') + len(choices.split("\n")))).lower() in result)

        trust_pk_np_list.append(trust_pk_np)
        # trust_ck_np_list.append(trust_ck_np)
        unkown_np_list.append(unknown_np)

        print("current neutral prompt trust pk acc: ", np.mean(trust_pk_np_list))
        # print("current neutral prompt trust ck acc: ", np.mean(trust_ck_np_list))
        print("current neutral prompt unknown: ", np.mean(unkown_np_list))

        # trust own prompt, ck in context, ask to use own knowledge
        result = item['tokp_result'] = result.split("Final Choice:")[-1].lower().strip().strip("unknown").strip().strip(".").strip("]").strip("[").strip(".").strip()
        if len(result) > 1:
            result = result[0]

        trust_pk_tokp = (answer.lower() in result)
        # trust_ck_tokp = (result == "1")
        unknown_tokp = (str(chr(ord('A') + len(choices.split("\n")))).lower() in result)
        
        trust_pk_tokp_list.append(trust_pk_tokp)
        # trust_ck_tokp_list.append(trust_ck_tokp)
        unkown_tokp_list.append(unknown_tokp)

        item['trust_pk_tokp'] = trust_pk_tokp
        # item['trust_ck_tokp'] = trust_ck_tokp
        item['unknown_tokp'] = unknown_tokp

        print("current trust own prompt trust pk acc: ", np.mean(trust_pk_tokp_list))
        # print("current trust own prompt trust ck acc: ", np.mean(trust_ck_tokp_list))
        print("current trust own prompt unknown: ", np.mean(unkown_tokp_list))



# Example usage
model = "o1-preview" # "gpt-4o-mini" or "LLAMA_3_70B"
input_file = f'./data/openbookQA/test_complete_{model}_complement.json'
output_file_golden = f'./output/openbookQA/test_complete_reasoning_{model}_complement_golden.json'
output_file = f'./output/openbookQA/test_complete_reasoning_{model}_harder_bygpt.json'

whole_evaluation(input_file, output_file, model)
golden_evaluation(input_file, output_file_golden, model)