# 🧊 Shape Reconstruction with NoiseSDF2NoiseSDF

This repository contains training and evaluation scripts for `NoiseSDF2NoiseSDF`. It supports datasets such as ShapeNet and ABC.
---

## 🚀 Training

To train the model, run the following commands:

### On ShapeNet:

```bash
# Full training
python main.py --config ./config/train_config/full_train.json

# Training with 0.02-level input noise
python main.py --config ./config/train_config/full_train_0.02level_noise.json
```

### On ABC Dataset:

```bash
# Finetune on ABC
python main.py --config ./config/train_config/abc_finetune.json

# Finetune with 0.02-level input noise
python main.py --config ./config/train_config/abc_finetune_0.02.json
```

---

## 🧪 Evaluation

To evaluate a trained model:

```bash
python evalute.py --config ./config/test_config/test_fine_tuneing_noise.json --model ae -c <category_number>
```

* Replace `<category_number>` with the category ID.
* Make sure the correct checkpoint is specified in the config file (stored under the `checkpoints/` directory).

---

## 📁 Checkpoints

All model checkpoints are saved in the `checkpoints/` directory. You can switch between them by modifying the `"ckpt"` field in your config files.

---

## Dataset Dir Structure

Our dataset Structure just like 3DS2V do. `abc` is regarded as a subcategory in shapenet. The data-processing code is referenced in `References`. 

```
shapenet
├── mesh
│   ├── 02691156
│   ├── 02747177
│   ├── 02773838
│   ├── 02801938
│   ├── 02808440
│   ├── 02818832
│   └── 02828884
|       abc    
└── point
    ├── 02691156
    ├── 02747177
    ├── 02773838
    ├── 02801938
    ├── 02808440
    ├── 02818832
    └── 02828884
        abc
```

## 🔗 References

* **Autoencoder Backbone**: [`models/models_ae.py`](https://github.com/1zb/3DShape2VecSet)
* **VQ-VAE Module**: [`models/modeling_vqvae.py`](https://github.com/1zb/3DILG)
* **Datasets**:

  * ShapeNet: [Google Drive](https://drive.google.com/drive/folders/1UFPi_UklH5clWKxxeL1IsxfjdUfc7i4x)
  * ABC, Famous, Real: [CG TU Wien (PPSurf)](https://github.com/cg-tuwien/ppsurf/tree/main/datasets)
* **Data Processing Scripts**: [SDF Generation](https://github.com/1zb/sdf_gen)

