
## Controlling Vision-Language Models for Universal Image Restoration

This is the implementation of submission 'Controlling Vision-Language Models for Universal Image Restoration'.

![daclip](figs/teaser.pdf)




## How to Run the Code?

### Dependenices

* OS: Ubuntu 20.04
* nvidia :
	- cuda: 11.7
	- cudnn: 8.5.0
* python3
* pytorch >= 1.13.0
* Python packages: `pip install -r requirements.txt`


### Dataset Preparation

Preparing the training and testing datasets following our paper Dataset Construction section as:

```bash
#### for training dataset ####
datasets/universal/train


#### for testing dataset ####
datasets/universal/val

```

Then get into the `codes/config/daclip-sde` directory and modify the dataset paths in option files in 
`options/train.yml` and `options/tes.yml`.


### Train
The main code for training is in `codes/config/daclip-sde` and the core network for DA-CLIP is in `codes/open_clip/daclip_model.py`.

You can train the model following below bash scripts:

```bash
cd codes/config/daclip-sde

# For single GPU:
python3 train.py -opt=options/train.yml

# For distributed training, need to change the gpu_ids in option file
python3 -m torch.distributed.launch --nproc_per_node=2 --master_poer=4321 train.py -opt=options/train.yml --launcher pytorch
```

Then the models and training logs will save in `log/universal-ir`. 
You can print your log at time by running `tail -f log/universal-ir/train_universal-ir_***.log -n 100`.

### Evaluation
To evalute our method, please modify the benchmark path and model path and run

```bash
cd codes/config/universal-ir
python test.py -opt=options/test.yml
```


---

#### --- Thanks for your interest! --- ####

