%This code implements GRASPEL algorithm for graph spectral learning
clear all; 
load USPS;%data matrix
gnd=gnd-1;%labels


DoSpectralCluster=1;
Subset=[0:9];%for selecting a subset of the data
num_cluster=length(Subset);%for selecting a subset of the data and spectral clustering
DoGRASPEL=1;%choose 1 if using GRASPEL iterations; choose 0 if only using kNN graph as output
num_eigs=5*num_cluster;%for spectral clustering
Nskip=1 ;% for selecting a subset of the data: when Nskip=2, it means only 50% data selected 
k=2;% for setting up the kNN graph
TestResistance=0;% choose 1 to check if effective resistance distances agree with data distance
samplePerc=5e-2;%top (bottom) perc. sorted nodes as candidate edges
edge_iter=1e-4;%edge budget per iteration: 1% means 1% # of nodes
sig=1e3;%feature variance
tol=10; %embedding distortion tolerance should be greater than 1.0
maxIter=100;%max GRASPEL iterations
num_test=10;%number of kmean clustering runs
fnameOUT='Gf.mtx';%final (output) graph after GRASPEL iterations

% Pick up a subset from the original data set
[idx,val]=find(gnd==[Subset]);
fea=fea(idx,:);
gnd=gnd(idx);

idx2=1:Nskip:length(fea(:,1));
fea=fea(idx2,:);
gnd=gnd(idx2);
 
%data size
[num_node,dim]=size(fea);

%feature preprocessing
fea=(fea-mean(fea,2));
fea=fea/norm(fea)*dim;

%GRASPEL iteration starts here
[Gf,variationRatio,cost, numIter] = FiedlerConstruct(fea,samplePerc,edge_iter,sig,maxIter,k,DoGRASPEL,tol);

%Final graph density check
num_edge=(length(Gf.Edges.Weight));
density=num_edge/num_node
[L,A]=getLaplacian(Gf,sig); 

if DoSpectralCluster==1
%spectral clustering & drawing
D=L+A;
[Us, vals] = eigs(L , num_eigs,'smallestabs');

%solution quality measures using NMI and ACC for spectral clustering
avgnmi=[];%NMI metric
avgacc=[];%ACC metric

    %Final result is computed by averaging multiple runs
    for i=1:num_test
    [idxSC,C]=kmeans(Us(:,2:num_cluster),num_cluster);
    avgnmi=[avgnmi;nmi(idxSC,gnd+1)];
    avgacc=[avgacc;accuracy(gnd+1,idxSC)];
    end
    nmiRes=mean(maxk(avgnmi,num_test))
    accRes=mean(maxk(avgacc,num_test))
    figure;plot(diag(vals),'*');

    % spectral graph drawing using labels (edges are not shown)
    figure;plot(Gf,'XData',Us(:,2),'YData',Us(:,3),'ZData',Us(:,4),'NodeCData',gnd,'edgecolor','none');
%     figure;plot(log(variationRatio))
end

%test distance embedding
if TestResistance==1
   [Rdist,Xdist, EdgeList]=testResistance(Gf,fea, num_test,sig);
end

%store the matrix for the learned graph
mtxwrite(fnameOUT,L);

 

 