function [Rdist,Xdist, EdgeList]=testResistance(graph,fea,num_sample,sig)
A=adjacency(graph,'weighted');
D=diag(sum(A,2));
L=D-A; 
L=L+1/sig^2*speye(size(L,1)); 
[num_node,dim]=size(fea);

Rdist=[];% Eff Res. distance
Xdist=[];% Data distance
EdgeList=[];
[R, pp, S] = chol(L);


for i=1:num_sample
    epq=zeros(num_node,1);
    rng(2*i)
    p=randi(num_node);   
    rng(2*i+1)
    q=randi(num_node);
    epq(p)=1;
    epq(q)=-1;
    x= S*(R\(R'\(S'*epq)));
    Rpq=epq'*x;
    Xpq=getDistance(fea,p,q);
    Rdist=[Rdist;Rpq];
    Xdist=[Xdist;Xpq];
    EdgeList=[EdgeList;p q];
end
% figure
% plot(Rdist,Xdist,"*")
corrcoef(Rdist,Xdist)