import params

def gemini_evaluate_batch(message_list, gemini_client):
    """
    Evaluate a batch of prompts asynchronously using Gemini's chat API.
    
    Args:
        prompts: A list of list of message dicts (each prompt is a list of chat messages).
    
    Returns:
        responses: A list of responses from the model for each prompt.
    """
    responses = []

    for messages in message_list:
        message = messages[0]["content"] if messages else "" # [role: user, content: prompt]
        
        # Send the prompt using Gemini chat API and get the response
        response = gemini_client.models.generate_content(
            model=params.gemini_model, contents=message
        )
        responses.append(response.text)  # Extracting the response text

    return responses