import fire

from schemas import ClassificationTaskBase
from tasks import load_evaluation_tasks, EvalMode


def main(task: str):
    from termcolor import colored
    try:
        evaluation_task: ClassificationTaskBase = load_evaluation_tasks(EvalMode.CLASSIFICATION, [task])[0]
        task_type = EvalMode.CLASSIFICATION
    except ModuleNotFoundError:
        evaluation_task: ClassificationTaskBase = load_evaluation_tasks(EvalMode.GENERATION, [task])[0]
        task_type = EvalMode.GENERATION
    except:
        raise ValueError(f"Task {task} not found.")

    if task_type == EvalMode.CLASSIFICATION:
        print(f"Label field: {evaluation_task.label_field}")
    print(f"Required input fields: {evaluation_task.required_input_fields()}")
    for d in evaluation_task.load():
        for input_field in evaluation_task.required_input_fields():
            print(colored(f"{input_field}: {d[input_field]}", "blue"))

        if task_type == EvalMode.CLASSIFICATION:
            print(colored(f"{evaluation_task.label_field}: {d[evaluation_task.label_field]}", "green"))
        input(f"** Press Enter to continue... **")


if __name__ == "__main__":
    fire.Fire(main)
