def get_average(numbers: list[int | bool | float]) -> float:
    if len(numbers) == 0:
        return -1
    if isinstance(numbers[0], bool):
        numbers = [int(x) for x in numbers]
    return sum(numbers) / len(numbers)


def get_f1(numbers: list[dict[str, bool]]) -> float:
    if len(numbers) == 0:
        return -1
    tp = sum([1 for x in numbers if x["pred"] and x["gt"]])
    fp = sum([1 for x in numbers if x["pred"] and not x["gt"]])
    fn = sum([1 for x in numbers if not x["pred"] and x["gt"]])
    precision = tp / (tp + fp) if tp + fp > 0 else 0
    recall = tp / (tp + fn) if tp + fn > 0 else 0
    f1 = 2 * precision * recall / (precision + recall) if precision + recall > 0 else 0
    return f1
