#!/bin/bash

# Define parameters
DATASET="bios"
BASE_MODEL="BERT_mu_bs16_lr0.0005_e2_sgd_wd1e-06"
EMBEDDING_TYPE="pooler"
SAVE="True"
SAMPLE="False"

# Define multiple seeds to test
SEEDS=(1 2 3 4 5)

# Define projection methods to test
PROJ_METHODS=("orig" "LEACE" "SAL" "opt-sep-proj")

# Define lambda values to test
LAMBDA_VALUES=(1 0.1 0.01 0.001 0.0001)

# Set to True if your fine-tuned models were trained on sampled data
FINETUNED_SAMPLE=False

# Create a timestamp for the result file
RESULT_FILE="lambda_sweep_multi_seed_full.csv"

echo "Starting lambda sweep across multiple projection methods, seeds"
echo "Results will be saved to: results/last_layer/$RESULT_FILE"

# Loop through seeds
for seed in "${SEEDS[@]}"
do
    echo "============================================="
    echo "Processing seed: $seed"
    echo "============================================="

    # Loop through projection methods
    for proj_method in "${PROJ_METHODS[@]}"
    do
        echo "============================================"
        echo "Processing projection method: $proj_method"
        echo "============================================"
        
        # Loop through lambda values for each projection method
        for lambda in "${LAMBDA_VALUES[@]}"
        do
            echo "Running with lambda = $lambda"
            
            # Handle special parameters for causal-LEACE if needed
            EXTRA_ARGS=""
            if [[ "$proj_method" == "causal-LEACE" ]]; then
                EXTRA_ARGS="--causal_LEACE_variant estimate_y"
            fi

            
            
            python eval_last_layer.py \
                --dataset $DATASET \
                --model_name $BASE_MODEL \
                --embedding_type $EMBEDDING_TYPE \
                --proj_method $proj_method \
                --seeds $seed \
                --sample_data $SAMPLE \
                --lambda_val $lambda \
                --save $SAVE \
                --result_file_name $RESULT_FILE \
                $EXTRA_ARGS
            
            echo "Completed run with seed = $seed, projection method = $proj_method, lambda = $lambda"
            echo "---------------------------------"
        done
    done
done

echo "Lambda sweep completed for all seeds, projection methods, and lambda values."
echo "Results saved to: results/last_layer/$RESULT_FILE"