#!/bin/bash
set -e  # Exit immediately if a command exits with a non-zero status
echo "Simulating GitHub Actions workflow locally"

# Step 1: Clean up any existing build artifacts
echo "Cleaning up old build artifacts..."
rm -rf build dist *.egg-info

# Step 2: Set up Python (assuming you have pyenv installed)
echo "Setting up Python..."
pyenv local 3.11.5  # This sets up the version from the GitHub workflow

# Step 3: Create and activate a virtual environment
echo "Creating virtual environment..."
python -m venv .env.test
source .env.test/bin/activate

# Step 4: Install dependencies
echo "Installing dependencies..."
python -m pip install --upgrade pip
pip install pytest pytest-cov numpy scipy scikit-learn torch transformers
pip install -r requirements.txt

# Step 5: Run tests with coverage
echo "Running tests..."
PYTHONPATH=$PYTHONPATH:$(pwd) pytest -rx tests/

# Step 6: Cleanup
echo "Cleaning up..."
deactivate
# Use sudo if regular rm fails
rm -rf .env.test || sudo rm -rf .env.test

echo "Local simulation completed"
