import cv2,os
from PIL import Image
def fcv(imgpath, imgpath_mask,image_save_path):
    mask_path = mask_fc(imgpath, imgpath_mask,image_save_path)
    mask = cv2.imread(mask_path)
    img_o = cv2.imread(imgpath)
   
    alpha=0.5
    beta=1
    output=img_o.copy()
    result = cv2.addWeighted(mask, alpha, output, beta,0)
    cv2.imwrite(image_save_path, result)

def mask_fc(imgpath, imgpath_mask,image_save_path):
    img = Image.open(imgpath).convert('RGBA')
    img_m = Image.open(imgpath_mask).convert('RGBA')
    h_m,w_m=img_m.size
    red_pixel=(0,255,0,0) #
    green_pixel=(255,0,0,0)
    yellow_pixel=(255,255,0,0)
    black_pixel=(0,0,0,255)
    white_pixel=(255,255,255,255)
    for i in range(int(h_m)):
        for j in range(int(w_m)):
            if img_m.getpixel((i,j))==black_pixel:
                img_m.putpixel((i,j),(0,0,0,0))
            elif img_m.getpixel((i,j))==white_pixel:
                img_m.putpixel((i,j),(255,255,0,100))
    print('MASKdone')
    img_m.save(image_save_path)

    return image_save_path

def merge_5(save_path,result_path):
    img1 = Image.open(save_path+f'{0}'+'.png')
    img2 = Image.open(save_path+f'{1}'+'.png')
    img3 = Image.open(save_path+f'{2}'+'.png')
    img4 = Image.open(save_path+f'{3}'+'.png')
    img5 = Image.open(save_path+f'{4}'+'.png')

    width1, height1 = img1.size
    width2, height2 = img2.size
    width3, height3 = img3.size
    width4, height4 = img4.size
    width5, height5 = img5.size

    new_width = width1 + width2 + width3 + width4 + width5 + 40
    new_height = max(height1, height2, height3, height4, height5)
    new_img = Image.new('RGBA', (new_width, new_height), (255, 255, 255, 255))

    new_img.paste(img1, (0, 0))
    new_img.paste(img2, (width1+10, 0))
    new_img.paste(img3, (width1+width2+20, 0))
    new_img.paste(img4, (width1+width2+width3+30, 0))
    new_img.paste(img5, (width1+width2+width3+width4+40, 0))

    new_img.save(result_path)

def merge_5_1(save_path,result_path):
    img1 = Image.open(save_path+f'{1}'+'.png')
    img2 = Image.open(save_path+f'{2}'+'.png')
    img3 = Image.open(save_path+f'{3}'+'.png')
    img4 = Image.open(save_path+f'{4}'+'.png')
    img5 = Image.open(save_path+f'{5}'+'.png')

    width1, height1 = img1.size
    width2, height2 = img2.size
    width3, height3 = img3.size
    width4, height4 = img4.size
    width5, height5 = img5.size

    new_width = width1 + width2 + width3 + width4 + width5 + 40
    new_height = max(height1, height2, height3, height4, height5)

    new_img = Image.new('RGBA', (new_width, new_height), (255, 255, 255, 255))

    new_img.paste(img1, (0, 0))
    new_img.paste(img2, (width1+10, 0))
    new_img.paste(img3, (width1+width2+20, 0))
    new_img.paste(img4, (width1+width2+width3+30, 0))
    new_img.paste(img5, (width1+width2+width3+width4+40, 0))

    new_img.save(result_path)

img = ""
mask = ""
gt = ""
result_path = ''

merge_5_1(img,result_path+'raw.png')
merge_5(mask,result_path+'mask.png')
merge_5_1(gt,result_path+'gt.png')

print('done')
